/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justenoughprofessions;

import com.mrbysco.justenoughprofessions.compat.CompatibilityHelper;
import com.mrbysco.justenoughprofessions.jei.ProfessionCategory;
import com.mrbysco.justenoughprofessions.jei.ProfessionEntry;
import com.mrbysco.justenoughprofessions.jei.ProfessionWrapper;
import java.util.LinkedList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ForgeProfessionPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("justenoughprofessions", "jei_plugin");
    public static final RecipeType<ProfessionWrapper> PROFESSION_TYPE = RecipeType.create((String)"justenoughprofessions", (String)"professions", ProfessionWrapper.class);

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ProfessionCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42616_), new RecipeType[]{PROFESSION_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42601_), new RecipeType[]{PROFESSION_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        LinkedList<ProfessionWrapper> entries = new LinkedList<ProfessionWrapper>();
        for (VillagerProfession profession : ForgeRegistries.VILLAGER_PROFESSIONS) {
            if (profession == VillagerProfession.f_35585_) continue;
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            for (PoiType poiType : ForgeRegistries.POI_TYPES.getValues()) {
                if (!profession.f_219629_().test(ForgeRegistries.POI_TYPES.getHolder((Object)poiType).orElse(null))) continue;
                for (BlockState state : poiType.f_27325_()) {
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()));
                    if (block == null) continue;
                    ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession));
                    ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    if (stack.m_41619_() || knownItems.contains(location)) continue;
                    stacks.add(stack);
                    knownItems.add(location);
                }
            }
            if (stacks.isEmpty()) continue;
            entries.add(new ProfessionWrapper(new ProfessionEntry(profession, stacks)));
        }
        registration.addRecipes(PROFESSION_TYPE, entries);
    }
}

