/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.CakeCaveStructurePiece;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.UndergroundTemplateStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACLootTableRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class GingerbreadHousePiece
extends UndergroundTemplateStructurePiece {
    public static final ResourceLocation TOWN_CENTER_TEMPLATE = new ResourceLocation("alexscaves", "gingerbread_town_center");
    public static final ResourceLocation[] HOUSE_TEMPLATES = new ResourceLocation[]{new ResourceLocation("alexscaves", "gingerbread_house_0"), new ResourceLocation("alexscaves", "gingerbread_house_1"), new ResourceLocation("alexscaves", "gingerbread_house_2"), new ResourceLocation("alexscaves", "gingerbread_house_3"), new ResourceLocation("alexscaves", "gingerbread_house_4"), new ResourceLocation("alexscaves", "gingerbread_house_5"), new ResourceLocation("alexscaves", "gingerbread_house_6"), new ResourceLocation("alexscaves", "gingerbread_house_7"), new ResourceLocation("alexscaves", "gingerbread_house_8"), new ResourceLocation("alexscaves", "gingerbread_house_9")};

    public GingerbreadHousePiece(StructureTemplateManager manager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
        super((StructurePieceType)ACStructurePieceRegistry.GINGERBREAD_HOUSE.get(), 0, manager, resourceLocation, resourceLocation.toString(), GingerbreadHousePiece.makeSettings(rotation), pos);
    }

    public GingerbreadHousePiece(StructureTemplateManager manager, CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.GINGERBREAD_HOUSE.get(), tag, manager, (ResourceLocation x) -> GingerbreadHousePiece.makeSettings(Rotation.valueOf((String)tag.m_128461_("Rotation"))));
    }

    public GingerbreadHousePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.f_226956_(), tag);
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74392_(true).m_163782_(false);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
    }

    @Override
    public int minimumDepthBeneathSurface() {
        return 35;
    }

    protected void m_213704_(String string, BlockPos pos, ServerLevelAccessor accessor, RandomSource random, BoundingBox box) {
        if (string.equals("loot_chest")) {
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)accessor, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)ACLootTableRegistry.GINGERBREAD_TOWN_CHEST);
        }
        accessor.m_7731_(pos, Blocks.f_50627_.m_49966_(), 10);
        for (Direction neighborDir : ACMath.HORIZONTAL_DIRECTIONS) {
            BlockPos offset = pos.m_121945_(neighborDir);
            if (!accessor.m_8055_(offset).m_204336_(BlockTags.f_13032_)) continue;
            accessor.m_46865_(offset).m_8113_(offset);
        }
        accessor.m_6289_(pos, accessor.m_8055_(pos).m_60734_());
    }

    @Override
    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos structurePos) {
        super.m_213694_(level, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, structurePos);
        BlockPos center = this.f_73383_.m_162394_().m_175288_(this.f_73383_.m_162396_());
        BoundingBox box = new BoundingBox(this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 1, this.f_73383_.m_162401_());
        HashSet supportsNeededBelow = Sets.newHashSet();
        BlockPos.m_121919_((BoundingBox)box).forEach(pos -> {
            if (!(level.m_8055_(pos).m_60795_() || level.m_6425_(pos.m_7495_()).m_76178_() && level.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_()))) {
                supportsNeededBelow.add(pos.m_7949_());
            }
        });
        Direction roadDirection = this.m_6830_().m_55954_(Direction.NORTH);
        BlockPos endOfRoad = center.m_5484_(roadDirection, Math.max(this.m_73547_().m_71056_(), this.m_73547_().m_71058_()) / 2);
        BlockPos.m_121990_((BlockPos)center, (BlockPos)endOfRoad).forEach(pos -> {
            BlockPos roadPos = this.getCaveHeight((BlockPos)pos, level, randomSource).m_7495_();
            if (boundingBox.m_71051_((Vec3i)roadPos.m_175288_(boundingBox.m_162396_())) && level.m_8055_(roadPos).m_204336_(ACTagRegistry.GINGERBREAD_TOWN_GEN_REPLACEABLES)) {
                level.m_7731_(roadPos, ((Block)ACBlockRegistry.GINGERBREAD_BRICKS.get()).m_49966_(), 3);
            }
        });
        BlockPos.MutableBlockPos above = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos grounded = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos groundedInBox = new BlockPos.MutableBlockPos();
        for (BlockPos pos2 : supportsNeededBelow) {
            grounded.m_122178_(pos2.m_123341_(), pos2.m_123342_() - 1, pos2.m_123343_());
            above.m_122178_(pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_());
            groundedInBox.m_122178_(pos2.m_123341_(), boundingBox.m_162396_() + 1, pos2.m_123343_());
            if (!boundingBox.m_71051_((Vec3i)groundedInBox)) continue;
            int maxYDown = 3 + randomSource.m_188503_(3);
            for (int yDown = 0; !(level.m_8055_((BlockPos)grounded).m_60819_().m_76178_() && level.m_8055_((BlockPos)grounded).m_60838_((BlockGetter)level, (BlockPos)grounded) || grounded.m_123342_() <= level.m_141937_() || yDown >= maxYDown); ++yDown) {
                if (yDown == 0 && !level.m_8055_((BlockPos)above).m_60838_((BlockGetter)level, (BlockPos)above)) {
                    level.m_7731_((BlockPos)grounded, ((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()).m_49966_(), 3);
                    level.m_7731_(grounded.m_7495_(), ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_(), 3);
                } else {
                    level.m_7731_((BlockPos)grounded, (float)yDown < (float)maxYDown * 0.4f ? ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_() : ((Block)ACBlockRegistry.CAKE_LAYER.get()).m_49966_(), 3);
                }
                grounded.m_122184_(0, -1, 0);
            }
        }
    }

    public void checkedSetBlock(WorldGenLevel level, BlockPos position, BlockState state) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            level.m_7731_(position, state, 128);
        }
    }

    @Override
    public boolean placeInHighestCave() {
        return true;
    }

    @Override
    public boolean discardIfNotOnGround() {
        return true;
    }

    @Override
    public boolean sinkByEdges() {
        return false;
    }

    @Override
    protected BlockPos getCaveHeight(BlockPos currentStructureCenter, WorldGenLevel level, RandomSource randomSource) {
        return currentStructureCenter.m_175288_((int)CakeCaveStructurePiece.calculatePlateauHeight(currentStructureCenter.m_123341_(), currentStructureCenter.m_123343_(), 7, true));
    }

    @Override
    public int moveDownBy() {
        return 1;
    }
}

