/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.AbstractCaveGenerationStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class AcidPitStructurePiece
extends AbstractCaveGenerationStructurePiece {
    public AcidPitStructurePiece(BlockPos chunkCorner, BlockPos holeCenter, int bowlHeight, int bowlRadius) {
        super((StructurePieceType)ACStructurePieceRegistry.ACID_PIT.get(), chunkCorner, holeCenter, bowlHeight, bowlRadius);
    }

    public AcidPitStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.ACID_PIT.get(), tag);
    }

    public AcidPitStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        boolean flag = false;
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveAbove = new BlockPos.MutableBlockPos();
        carve.m_122178_(cornerX, cornerY, cornerZ);
        carveAbove.m_122178_(cornerX, cornerY, cornerZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 15; y >= 0; --y) {
                    carve.m_122178_(cornerX + x, Mth.m_14045_((int)(cornerY + y), (int)level.m_141937_(), (int)level.m_151558_()), cornerZ + z);
                    carveAbove.m_122178_(carve.m_123341_(), carve.m_123342_() + 1, carve.m_123343_());
                    float widthSimplexNoise1 = Math.min(ACMath.sampleNoise3D(carve.m_123341_(), carve.m_123342_(), carve.m_123343_(), (float)this.radius) - 0.5f, 1.0f) * 0.94f;
                    float heightSimplexNoise1 = ACMath.sampleNoise3D(carve.m_123341_() + 440, 0, carve.m_123343_() - 440, 20.0f) * 0.5f + 0.5f;
                    double yDist = ACMath.smin(1.0f - (float)Math.abs(this.holeCenter.m_123342_() - carve.m_123342_()) / ((float)this.height * heightSimplexNoise1), 0.7f, 0.3f);
                    double distToCenter = carve.m_203202_((double)this.holeCenter.m_123341_(), (double)carve.m_123342_(), (double)this.holeCenter.m_123343_());
                    double targetRadius = yDist * (double)((float)this.radius + widthSimplexNoise1 * (float)this.radius) * (double)this.radius;
                    double acidRadius = targetRadius - targetRadius * 0.25;
                    if (!(distToCenter <= targetRadius)) continue;
                    FluidState fluidState = this.checkedGetBlock(level, (BlockPos)carve).m_60819_();
                    flag = true;
                    if (this.isPillarBlocking(carve, yDist)) {
                        if (fluidState.m_76178_()) continue;
                        this.checkedSetBlock(level, (BlockPos)carve, ((Block)ACBlockRegistry.RADROCK.get()).m_49966_());
                        continue;
                    }
                    if (carve.m_123342_() < -10) {
                        this.checkedSetBlock(level, (BlockPos)carve, ((LiquidBlock)ACBlockRegistry.ACID.get()).m_49966_());
                        this.surroundCornerLiquid(level, carve);
                        continue;
                    }
                    if (this.isTouchingNonAcidLiquid(level, carve)) {
                        this.surroundCornerMud(level, carve);
                        this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_220864_.m_49966_());
                    }
                    this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_50627_.m_49966_());
                }
            }
        }
        if (flag) {
            this.replaceBiomes(level, ACBiomeRegistry.TOXIC_CAVES, 20);
        }
    }

    private boolean isPillarBlocking(BlockPos.MutableBlockPos carve, double yDist) {
        float f;
        float sample = ACMath.sampleNoise3D(carve.m_123341_(), 0, carve.m_123343_(), 40.0f) + ACMath.sampleNoise3D(carve.m_123341_() - 440, 0, carve.m_123343_() + 412, 15.0f) * 0.2f + ACMath.sampleNoise3D(carve.m_123341_() - 100, carve.m_123342_(), carve.m_123343_() - 400, 100.0f) * 0.9f + 0.6f;
        return sample >= 0.35f * (f = ACMath.smin((float)yDist / 0.67f, 1.0f, 0.2f) + 1.0f) && sample <= ACMath.smin(1.0f, (float)yDist / 0.67f + 0.35f, 0.2f) * f;
    }

    private void surroundCornerLiquid(WorldGenLevel level, BlockPos.MutableBlockPos center) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : ACMath.NOT_UP_DIRECTIONS) {
            offset.m_122190_((Vec3i)center);
            offset.m_122173_(dir);
            BlockState state = this.checkedGetBlockIgnoreY(level, (BlockPos)offset);
            if (state.m_60819_().m_192917_((Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get())) continue;
            this.checkedSetBlock(level, (BlockPos)offset, Blocks.f_220864_.m_49966_());
        }
    }

    private void surroundCornerMud(WorldGenLevel level, BlockPos.MutableBlockPos center) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            offset.m_122190_((Vec3i)center);
            offset.m_122173_(dir);
            BlockState state = this.checkedGetBlock(level, (BlockPos)offset);
            if (state.m_60819_().m_76178_() || state.m_60819_().m_192917_((Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get())) continue;
            this.checkedSetBlock(level, (BlockPos)offset, Blocks.f_220864_.m_49966_());
        }
    }

    private boolean isTouchingNonAcidLiquid(WorldGenLevel level, BlockPos.MutableBlockPos center) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            offset.m_122190_((Vec3i)center);
            offset.m_122173_(dir);
            FluidState state = this.checkedGetBlock(level, (BlockPos)offset).m_60819_();
            if (state.m_76178_() || state.m_192917_((Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get())) continue;
            return true;
        }
        FluidState state = this.checkedGetBlock(level, (BlockPos)center).m_60819_();
        return !state.m_76178_() && !state.m_192917_((Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get());
    }
}

