/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CookieShelfFeature
extends Feature<NoneFeatureConfiguration> {
    public CookieShelfFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource randomSource;
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        boolean placedFirst = this.tryPlaceCookie(level, pos, randomSource = context.m_225041_());
        if (placedFirst && randomSource.m_188499_()) {
            this.tryPlaceCookie(level, pos.m_6630_(2 + randomSource.m_188503_(3)), randomSource);
        }
        if (placedFirst && randomSource.m_188499_()) {
            this.tryPlaceCookie(level, pos.m_6625_(2 + randomSource.m_188503_(3)), randomSource);
        }
        return placedFirst;
    }

    private boolean tryPlaceCookie(WorldGenLevel level, BlockPos pos, RandomSource randomSource) {
        if (level.m_8055_(pos).m_60795_()) {
            ArrayList<Direction> possiblities = new ArrayList<Direction>();
            for (Direction possible : ACMath.HORIZONTAL_DIRECTIONS) {
                BlockPos check = pos.m_121945_(possible);
                BlockState checkState = level.m_8055_(check);
                if (!this.isSameChunk(pos, check) || !checkState.m_60713_((Block)ACBlockRegistry.CAKE_LAYER.get()) && !checkState.m_60713_((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get())) continue;
                possiblities.add(possible.m_122424_());
            }
            Direction direction = CookieShelfFeature.selectDirection(possiblities, randomSource);
            if (direction != null) {
                int cookieRadius = 4 + randomSource.m_188503_(3);
                BlockPos offsetBy = pos.m_5484_(direction.m_122424_(), cookieRadius / 3);
                double cookieRadiusSq = Math.pow(cookieRadius, 1.5);
                for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)offsetBy.m_7918_(-cookieRadius, 0, -cookieRadius), (BlockPos)offsetBy.m_7918_(cookieRadius, 0, cookieRadius))) {
                    if (!(blockpos1.m_123331_((Vec3i)offsetBy) <= cookieRadiusSq) || level.m_8055_(blockpos1).m_204336_(ACTagRegistry.UNMOVEABLE) || Math.abs(blockpos1.m_123341_() - offsetBy.m_123341_()) == cookieRadius || Math.abs(blockpos1.m_123343_() - offsetBy.m_123343_()) == cookieRadius) continue;
                    level.m_7731_(blockpos1, ((Block)ACBlockRegistry.COOKIE_BLOCK.get()).m_49966_(), 3);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isSameChunk(BlockPos pos, BlockPos check) {
        return SectionPos.m_123171_((int)pos.m_123341_()) == SectionPos.m_123171_((int)check.m_123341_()) && SectionPos.m_123171_((int)pos.m_123343_()) == SectionPos.m_123171_((int)check.m_123343_());
    }

    private static Direction selectDirection(List<Direction> directionList, RandomSource randomSource) {
        if (directionList.size() <= 0) {
            return null;
        }
        if (directionList.size() <= 1) {
            return directionList.get(0);
        }
        return directionList.get(randomSource.m_188503_(directionList.size() - 1));
    }
}

