/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MeltedCaramelEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class CaramelCubeEntity
extends Monster
implements PossessedByLicowitch {
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(CaramelCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_JUMP = SynchedEntityData.m_135353_(CaramelCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_JUMPED = SynchedEntityData.m_135353_(CaramelCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> POSSESSOR_LICOWITCH_ID = SynchedEntityData.m_135353_(CaramelCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float squishProgress;
    private float prevSquishProgress;
    private float jumpProgress;
    private float prevJumpProgress;
    private float jiggleTime;
    private float prevJiggleTime;
    protected static final EntityDimensions SMALL_DIMENSIONS = EntityDimensions.m_20398_((float)0.8f, (float)0.8f);
    protected static final EntityDimensions MEDIUM_DIMENSIONS = EntityDimensions.m_20398_((float)1.5f, (float)1.5f);
    protected static final EntityDimensions LARGE_DIMENSIONS = EntityDimensions.m_20398_((float)3.5f, (float)3.5f);

    public CaramelCubeEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new MoveHelper();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static boolean checkCaramelCubeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return CaramelCubeEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal());
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomDirectionGoal());
        this.f_21345_.m_25352_(4, (Goal)new KeepOnJumpingGoal());
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, y -> Math.abs(y.m_20186_() - this.m_20186_()) <= 4.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)0);
        this.f_19804_.m_135372_(WANTS_TO_JUMP, (Object)false);
        this.f_19804_.m_135372_(HAS_JUMPED, (Object)false);
        this.f_19804_.m_135372_(POSSESSOR_LICOWITCH_ID, (Object)-1);
    }

    public float getJumpProgress(float partialTick) {
        return (this.prevJumpProgress + (this.jumpProgress - this.prevJumpProgress) * partialTick) * 0.33f;
    }

    public float getSquishProgress(float partialTick) {
        return (this.prevSquishProgress + (this.squishProgress - this.prevSquishProgress) * partialTick) * 0.2f;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    protected float m_6118_() {
        float f = this.getSlimeSize() == 2 ? 0.3f : (this.getSlimeSize() == 1 ? 0.1f : 0.0f);
        return super.m_6118_() + f;
    }

    public int m_8132_() {
        return 0;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSlimeSize(compound.m_128451_("SlimeSize"), false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SlimeSize", this.getSlimeSize());
    }

    public void setSlimeSize(int i, boolean heal) {
        int size = Mth.m_14045_((int)i, (int)0, (int)2);
        this.f_19804_.m_135381_(SIZE, (Object)size);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(4.0f + 6.0f * (float)size));
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.25f + 0.1f * (float)size));
        this.m_21051_(Attributes.f_22281_).m_22100_(2.0 + (double)((float)size * 2.0f));
        if (heal) {
            this.m_21153_(this.m_21233_());
        }
    }

    protected int m_5639_(float f, float f1) {
        return super.m_5639_(f, f1) - 5;
    }

    public int getSlimeSize() {
        return Math.min((Integer)this.f_19804_.m_135370_(SIZE), 2);
    }

    public void setWantsToJump(boolean wantsToJump) {
        this.f_19804_.m_135381_(WANTS_TO_JUMP, (Object)wantsToJump);
    }

    public boolean wantsToJump() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_JUMP);
    }

    public void setHasJumped(boolean hasJumped) {
        this.f_19804_.m_135381_(HAS_JUMPED, (Object)hasJumped);
    }

    public boolean hasJumped() {
        return (Boolean)this.f_19804_.m_135370_(HAS_JUMPED);
    }

    @Override
    public void setPossessedByLicowitchId(int entityId) {
        this.f_19804_.m_135381_(POSSESSOR_LICOWITCH_ID, (Object)entityId);
    }

    @Override
    public int getPossessedByLicowitchId() {
        return (Integer)this.f_19804_.m_135370_(POSSESSOR_LICOWITCH_ID);
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.getPossessedByLicowitchId() == -1;
    }

    public boolean m_6779_(LivingEntity living) {
        LicowitchEntity licowitch;
        if (this.getPossessedByLicowitchId() != -1 && (licowitch = this.getPossessingLicowitch(this.m_9236_())) != null && licowitch.isFriendlyFire(living)) {
            return false;
        }
        return super.m_6779_(living);
    }

    public void m_8119_() {
        boolean squish;
        super.m_8119_();
        this.prevJumpProgress = this.jumpProgress;
        this.prevSquishProgress = this.squishProgress;
        this.prevJiggleTime = this.jiggleTime;
        boolean jumping = !this.m_20096_() && this.f_19797_ > 4;
        boolean bl = squish = !jumping && (this.wantsToJump() || this.hasJumped() && this.m_20096_());
        if (jumping && this.jumpProgress < 3.0f) {
            this.jumpProgress += 1.0f;
        }
        if (!jumping && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 1.0f;
        }
        if (squish && this.squishProgress < 5.0f) {
            this.squishProgress += 1.0f;
            if (this.squishProgress >= 5.0f) {
                this.setHasJumped(false);
            }
        }
        if (!squish && this.squishProgress > 0.0f) {
            this.squishProgress -= 1.0f;
        }
        if (this.hasJumped() && this.m_20096_()) {
            this.jiggleTime = 5.0f;
        } else if (this.jiggleTime > 0.0f) {
            if (this.jiggleTime == 4.0f) {
                this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            }
            if (this.jiggleTime > 4.0f) {
                this.spawnLandParticles();
            }
            this.jiggleTime -= 1.0f;
        }
        if (this.m_9236_().f_46443_) {
            this.spawnPossessedParticles(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), this.m_9236_());
        }
    }

    private void spawnLandParticles() {
        int i = 1 + this.getSlimeSize();
        for (int j = 0; j < i * 6; ++j) {
            float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            float f1 = this.f_19796_.m_188501_() * 0.5f + 0.65f;
            float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
            float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.CARAMEL_DROP.get(), this.m_20185_() + (double)f2, this.m_20186_() + (double)0.15f, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
        }
    }

    private void spawnMeltedCaramel() {
        int i = 1 + this.getSlimeSize();
        for (int j = 0; j < i; ++j) {
            float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            float f1 = this.f_19796_.m_188501_() * 0.5f + 0.65f;
            float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
            float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
            MeltedCaramelEntity meltedCaramel = (MeltedCaramelEntity)((EntityType)ACEntityRegistry.MELTED_CARAMEL.get()).m_20615_(this.m_9236_());
            Vec3 vec3 = new Vec3(this.m_20185_() + (double)f2, this.m_20186_() + 0.02, this.m_20189_() + (double)f3);
            meltedCaramel.m_146884_(ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), vec3));
            meltedCaramel.setDespawnsIn(40 + (i - 1) * 40);
            meltedCaramel.m_20256_(this.m_20184_().m_82542_(-1.0, 0.0, -1.0));
            this.m_9236_().m_7967_((Entity)meltedCaramel);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float damageValue) {
        boolean sup = super.m_6469_(damageSource, damageValue);
        if (sup) {
            this.spawnMeltedCaramel();
        }
        return sup;
    }

    public float getJiggleTime(float partialTick) {
        return (this.prevJiggleTime + (this.jiggleTime - this.prevJiggleTime) * partialTick) * 0.2f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setSlimeSize(this.f_19796_.m_188503_(3), true);
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (SIZE.equals(dataAccessor)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
                this.m_5841_();
            }
        }
        super.m_7350_(dataAccessor);
    }

    public EntityDimensions m_6972_(Pose pose) {
        switch (this.getSlimeSize()) {
            case 2: {
                return LARGE_DIMENSIONS;
            }
            case 1: {
                return MEDIUM_DIMENSIONS;
            }
        }
        return SMALL_DIMENSIONS;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        int ourSize = this.getSlimeSize();
        if (!this.m_9236_().f_46443_ && ourSize > 0 && this.m_21224_()) {
            Component component = this.m_7770_();
            boolean flag = this.m_21525_();
            float f = (float)ourSize / 4.0f;
            int j = ourSize - 1;
            int slimesSpawned = ourSize >= 2 ? 2 : 2 + this.f_19796_.m_188503_(2);
            for (int l = 0; l < slimesSpawned; ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                CaramelCubeEntity slime = (CaramelCubeEntity)((EntityType)ACEntityRegistry.CARAMEL_CUBE.get()).m_20615_(this.m_9236_());
                if (slime == null) continue;
                if (this.m_21532_()) {
                    slime.m_21530_();
                }
                slime.m_6593_(component);
                slime.m_21557_(flag);
                slime.m_20331_(this.m_20147_());
                slime.setSlimeSize(j, true);
                slime.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 0.5, this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)slime);
            }
        }
        super.m_142687_(reason);
    }

    protected void m_7625_(DamageSource source, boolean b) {
        if (this.getSlimeSize() == 0) {
            super.m_7625_(source, b);
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.5f * dimensions.f_20378_;
    }

    public int m_213860_() {
        return 2;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    protected SoundEvent m_7975_(DamageSource p_33631_) {
        return this.getSquishSound();
    }

    protected SoundEvent m_5592_() {
        return this.getSquishSound();
    }

    protected SoundEvent getJumpSound() {
        return this.getSquishSound();
    }

    protected SoundEvent getSquishSound() {
        return this.getSlimeSize() == 0 ? (SoundEvent)ACSoundRegistry.CARAMEL_CUBE_SMALL.get() : (SoundEvent)ACSoundRegistry.CARAMEL_CUBE_BIG.get();
    }

    class MoveHelper
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private boolean isAggressive;

        public MoveHelper() {
            super((Mob)CaramelCubeEntity.this);
            this.yRot = 180.0f * CaramelCubeEntity.this.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean aggressive) {
            this.yRot = yRot;
            this.isAggressive = aggressive;
        }

        public void setWantedMovement(double speed) {
            this.f_24978_ = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    float f = this.isAggressive ? 1.5f : 1.0f;
                    this.f_24974_.m_7910_((float)(this.f_24978_ * (double)f * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        CaramelCubeEntity.this.setWantsToJump(false);
                        this.jumpDelay = 20;
                        if (this.isAggressive) {
                            this.jumpDelay = 6;
                        }
                        CaramelCubeEntity.this.m_21569_().m_24901_();
                        CaramelCubeEntity.this.setHasJumped(true);
                        CaramelCubeEntity.this.m_5496_(CaramelCubeEntity.this.getJumpSound(), CaramelCubeEntity.this.m_6121_(), CaramelCubeEntity.this.m_6100_());
                    } else {
                        CaramelCubeEntity.this.f_20900_ = 0.0f;
                        CaramelCubeEntity.this.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                        CaramelCubeEntity.this.setWantsToJump(true);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    class FloatGoal
    extends Goal {
        public FloatGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            CaramelCubeEntity.this.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (CaramelCubeEntity.this.m_20069_() || CaramelCubeEntity.this.m_20077_()) && CaramelCubeEntity.this.m_21566_() instanceof MoveHelper;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (CaramelCubeEntity.this.m_217043_().m_188501_() < 0.8f) {
                CaramelCubeEntity.this.m_21569_().m_24901_();
            }
            if ((movecontrol = CaramelCubeEntity.this.m_21566_()) instanceof MoveHelper) {
                MoveHelper slime$slimemovecontrol = (MoveHelper)movecontrol;
                slime$slimemovecontrol.setWantedMovement(1.2);
            }
        }
    }

    class AttackGoal
    extends Goal {
        private int growTiredTimer;
        private int attackLogicCooldown = 0;

        public AttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = CaramelCubeEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return CaramelCubeEntity.this.m_6779_(livingentity) && CaramelCubeEntity.this.m_21566_() instanceof MoveHelper;
        }

        public void m_8056_() {
            this.growTiredTimer = AttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = CaramelCubeEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!CaramelCubeEntity.this.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            LivingEntity livingentity = CaramelCubeEntity.this.m_5448_();
            if (livingentity != null) {
                CaramelCubeEntity.this.m_21391_((Entity)livingentity, 10.0f, 10.0f);
                double dist = CaramelCubeEntity.this.m_20270_((Entity)livingentity);
                if (dist < (double)CaramelCubeEntity.this.m_20205_() + 0.25 + (double)livingentity.m_20205_() && CaramelCubeEntity.this.hasJumped() && CaramelCubeEntity.this.m_20096_() && this.attackLogicCooldown == 0) {
                    this.attackLogicCooldown = 5;
                    CaramelCubeEntity.this.m_5496_((SoundEvent)ACSoundRegistry.CARAMEL_CUBE_ATTACK.get(), CaramelCubeEntity.this.m_6121_(), CaramelCubeEntity.this.m_6100_());
                    livingentity.m_6469_(CaramelCubeEntity.this.m_269291_().m_269333_((LivingEntity)CaramelCubeEntity.this), (float)CaramelCubeEntity.this.m_21051_(Attributes.f_22281_).m_22135_());
                }
            }
            if (this.attackLogicCooldown > 0) {
                --this.attackLogicCooldown;
            }
            if ((movecontrol = CaramelCubeEntity.this.m_21566_()) instanceof MoveHelper) {
                MoveHelper slime$slimemovecontrol = (MoveHelper)movecontrol;
                slime$slimemovecontrol.setDirection(CaramelCubeEntity.this.m_146908_(), true);
            }
        }
    }

    class RandomDirectionGoal
    extends Goal {
        private float chosenDegrees;
        private int nextRandomizeTime;

        public RandomDirectionGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return CaramelCubeEntity.this.m_5448_() == null && (CaramelCubeEntity.this.m_20096_() || CaramelCubeEntity.this.m_20069_() || CaramelCubeEntity.this.m_20077_() || CaramelCubeEntity.this.m_21023_(MobEffects.f_19620_)) && CaramelCubeEntity.this.m_21566_() instanceof MoveHelper;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + CaramelCubeEntity.this.m_217043_().m_188503_(60));
                this.chosenDegrees = CaramelCubeEntity.this.m_217043_().m_188503_(360);
            }
            if ((movecontrol = CaramelCubeEntity.this.m_21566_()) instanceof MoveHelper) {
                MoveHelper slime$slimemovecontrol = (MoveHelper)movecontrol;
                slime$slimemovecontrol.setDirection(this.chosenDegrees, false);
            }
        }
    }

    class KeepOnJumpingGoal
    extends Goal {
        public KeepOnJumpingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !CaramelCubeEntity.this.m_20159_();
        }

        public void m_8037_() {
            MoveControl movecontrol = CaramelCubeEntity.this.m_21566_();
            if (movecontrol instanceof MoveHelper) {
                MoveHelper slime$slimemovecontrol = (MoveHelper)movecontrol;
                slime$slimemovecontrol.setWantedMovement(1.0);
            }
        }
    }
}

