/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.MagneticCavesAmbientParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class SugarFlakeParticle
extends TextureSheetParticle {
    private final float particleRandom;
    private final float maxLife;
    private final SpriteSet sprites;

    public SugarFlakeParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites) {
        super(world, x, y, z);
        this.sprites = sprites;
        this.maxLife = 50 + this.f_107223_.m_188503_(50);
        this.f_107225_ = (int)this.maxLife;
        this.f_107663_ = 0.15f + this.f_107223_.m_188501_() * 0.15f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.particleRandom = this.f_107223_.m_188501_();
        this.f_107226_ = -0.01f * this.f_107223_.m_188501_();
        this.f_107230_ = 0.0f;
        this.m_108337_(sprites.m_5819_(this.f_107225_, this.f_107225_));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
        if (!this.f_107220_) {
            this.m_108337_(this.sprites.m_5819_((int)(this.maxLife - (float)this.f_107225_), (int)this.maxLife));
            float f = this.maxLife - (float)this.f_107225_;
            float f1 = Math.min(f / this.maxLife, 1.0f);
            float worldRotation = (float)this.f_107208_.m_46467_() / 3.0f % 360.0f;
            double d0 = Math.cos(Math.toRadians(this.particleRandom * 30.0f + worldRotation)) * 2.0 * Math.pow(f1, 1.25);
            double d1 = Math.sin(Math.toRadians(this.particleRandom * 30.0f + worldRotation)) * 2.0 * Math.pow(f1, 1.25);
            this.f_107215_ += d0 * (double)0.01f;
            this.f_107217_ += d1 * (double)0.01f;
            this.f_107216_ -= (double)this.f_107226_ * (double)0.025f;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107218_ || (float)this.f_107225_ < this.maxLife - 1.0f && (this.f_107215_ == 0.0 || this.f_107217_ == 0.0)) {
                this.m_107274_();
            }
            if (!this.f_107220_) {
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
            }
            this.f_107230_ = (float)Math.sin((double)((float)this.f_107225_ / this.maxLife) * Math.PI) * 0.7f;
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        super.m_5744_(consumer, camera, partialTick);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Vec3 startPos = MagneticCavesAmbientParticle.getStartPosition(worldIn, false, x, y, z).m_82520_(0.0, (double)(0.15f + 0.5f * worldIn.f_46441_.m_188501_()), 0.0);
            SugarFlakeParticle particle = new SugarFlakeParticle(worldIn, x, startPos.f_82480_, z, this.spriteSet);
            return particle;
        }
    }
}

