/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.world.entity.HumanoidArm;

public class DeepOneModel
extends AdvancedEntityModel<DeepOneEntity>
implements ArmedModel {
    private final AdvancedModelBox body;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox head;
    private final AdvancedModelBox jaw;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox lleg;
    private final AdvancedModelBox headFins;
    private final ModelAnimator animator;

    public DeepOneModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.1667f, 2.1667f, 1.5f);
        this.body.setTextureOffset(0, 12).addBox(0.3333f, -15.1667f, -2.5f, 0.0f, 19.0f, 11.0f, 0.0f, false);
        this.body.setTextureOffset(0, 0).addBox(-6.6667f, -10.1667f, -6.5f, 13.0f, 14.0f, 9.0f, 0.0f, false);
        this.body.setTextureOffset(45, 15).addBox(-3.6667f, 3.8333f, -3.5f, 7.0f, 10.0f, 5.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(-0.1667f, 12.3333f, 1.5f);
        this.body.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(22, 29).addBox(0.0f, -5.5f, 0.0f, 0.0f, 12.0f, 12.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(-0.1667f, -10.1667f, -3.5f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(70, 9).addBox(-3.5f, -6.0f, -8.0f, 7.0f, 5.0f, 6.0f, 0.0f, false);
        this.head.setTextureOffset(22, 23).addBox(-3.5f, -1.0f, -8.0f, 7.0f, 9.0f, 9.0f, 0.0f, false);
        this.head.setTextureOffset(18, 53).addBox(-3.5f, -6.0f, -2.0f, 7.0f, 5.0f, 3.0f, 0.0f, false);
        this.head.setTextureOffset(0, 0).addBox(0.5f, -3.0f, -4.0f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.head.setTextureOffset(0, 0).addBox(-2.5f, -3.0f, -4.0f, 2.0f, 2.0f, 2.0f, 0.0f, true);
        this.headFins = new AdvancedModelBox((AdvancedEntityModel)this);
        this.headFins.setRotationPoint(-3.0f, -1.0f, -2.0f);
        this.head.addChild((BasicModelPart)this.headFins);
        this.setRotateAngle(this.headFins, -0.7854f, 0.0f, 0.0f);
        this.headFins.setTextureOffset(69, 20).addBox(-5.5f, -4.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, true);
        this.headFins.setTextureOffset(69, 20).addBox(6.5f, -4.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(0.0f, 3.0f, -0.5f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(44, 0).addBox(-3.5f, -1.0f, -7.5f, 7.0f, 6.0f, 9.0f, 0.25f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(-6.1667f, -4.1667f, -0.75f);
        this.body.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(0, 42).addBox(-3.5f, -2.0f, -3.75f, 4.0f, 19.0f, 5.0f, 0.0f, true);
        this.rarm.setTextureOffset(54, 30).addBox(-3.5f, 17.0f, -3.75f, 4.0f, 4.0f, 5.0f, 0.0f, true);
        this.rarm.setTextureOffset(0, 66).addBox(-3.5f, -2.0f, -3.75f, 4.0f, 19.0f, 5.0f, 0.25f, true);
        this.rarm.setTextureOffset(46, 47).addBox(-1.5f, -2.0f, 1.25f, 0.0f, 19.0f, 5.0f, 0.0f, true);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(5.8333f, -4.1667f, -2.25f);
        this.body.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(0, 42).addBox(-0.5f, -2.0f, -2.25f, 4.0f, 19.0f, 5.0f, 0.0f, false);
        this.larm.setTextureOffset(0, 66).addBox(-0.5f, -2.0f, -2.25f, 4.0f, 19.0f, 5.0f, 0.25f, false);
        this.larm.setTextureOffset(54, 30).addBox(-0.5f, 17.0f, -2.25f, 4.0f, 4.0f, 5.0f, 0.0f, false);
        this.larm.setTextureOffset(46, 47).addBox(1.5f, -2.0f, 2.75f, 0.0f, 19.0f, 5.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-2.1667f, 13.3333f, -1.5f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(56, 52).addBox(-1.5f, 0.5f, -1.0f, 3.0f, 8.0f, 3.0f, 0.0f, true);
        this.rleg.setTextureOffset(65, 43).addBox(-1.5f, 0.5f, -1.0f, 3.0f, 8.0f, 3.0f, 0.25f, true);
        this.rleg.setTextureOffset(29, 0).addBox(-4.5f, 8.5f, -4.0f, 6.0f, 0.0f, 6.0f, 0.0f, true);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(1.8333f, 13.3333f, -1.5f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(56, 52).addBox(-1.5f, 0.5f, -1.0f, 3.0f, 8.0f, 3.0f, 0.0f, false);
        this.lleg.setTextureOffset(65, 43).addBox(-1.5f, 0.5f, -1.0f, 3.0f, 8.0f, 3.0f, 0.25f, false);
        this.lleg.setTextureOffset(29, 0).addBox(-1.5f, 8.5f, -4.0f, 6.0f, 0.0f, 6.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(DeepOneEntity.ANIMATION_THROW);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.jaw, (float)Math.toRadians(45.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(15.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), (float)Math.toRadians(-15.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-65.0), (float)Math.toRadians(110.0), (float)Math.toRadians(65.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.jaw, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), (float)Math.toRadians(15.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-75.0), (float)Math.toRadians(10.0), (float)Math.toRadians(65.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(DeepOneEntity.ANIMATION_SCRATCH);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.jaw, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-75.0), (float)Math.toRadians(30.0), (float)Math.toRadians(65.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.jaw, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-75.0), (float)Math.toRadians(-30.0), (float)Math.toRadians(25.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.jaw, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-75.0), (float)Math.toRadians(-30.0), (float)Math.toRadians(-65.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.jaw, (float)Math.toRadians(35.0), 0.0f, 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-75.0), (float)Math.toRadians(30.0), (float)Math.toRadians(-25.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(DeepOneEntity.ANIMATION_BITE);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.rleg, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.lleg, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(30.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(30.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.head, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.move(this.head, 0.0f, -1.0f, -3.0f);
        this.animator.move(this.body, 0.0f, 1.0f, -1.0f);
        this.animator.move(this.rleg, 0.0f, -1.5f, -1.0f);
        this.animator.move(this.lleg, 0.0f, -1.5f, -1.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(65.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(3);
        this.animator.setAnimation(DeepOneEntity.ANIMATION_TRADE);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.head, (float)Math.toRadians(25.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.rarm, (float)Math.toRadians(-25.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(-10.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-25.0), (float)Math.toRadians(15.0), (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.animator.rotate(this.head, (float)Math.toRadians(15.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.rarm, (float)Math.toRadians(-25.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(-10.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-25.0), (float)Math.toRadians(15.0), (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(20);
        this.animator.rotate(this.head, (float)Math.toRadians(15.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.rarm, (float)Math.toRadians(-25.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(-10.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-25.0), (float)Math.toRadians(15.0), (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.larm, (float)Math.toRadians(-100.0), (float)Math.toRadians(25.0), (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
    }

    public void setupAnim(DeepOneEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float swim = entity.m_20998_(partialTick);
        float clampedYaw = netHeadYaw / 57.295776f;
        float fishPitchAmount = entity.getFishPitch(partialTick) / 57.295776f;
        float headPitchAmount = headPitch / 57.295776f;
        float walkSpeed = 1.0f;
        float walkDegree = 1.0f;
        float swimSpeed = 0.25f;
        float swimDegree = 0.5f;
        float walkAmount = Math.min(limbSwingAmount * 2.0f, 1.0f) * (1.0f - swim);
        float swimAmount = limbSwingAmount * swim;
        this.walk(this.head, 0.1f, 0.02f, false, 0.0f, 0.02f, ageInTicks, 1.0f);
        this.walk(this.tail, 0.1f, 0.05f, false, -1.0f, 0.05f, ageInTicks, 1.0f);
        this.walk(this.larm, 0.1f, 0.05f, true, -1.0f, 0.1f, ageInTicks, 1.0f);
        this.walk(this.rarm, 0.1f, 0.05f, false, -1.0f, -0.1f, ageInTicks, 1.0f);
        this.progressRotationPrev(this.body, walkAmount, (float)Math.toRadians(15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, walkAmount, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg, walkAmount, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg, walkAmount, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.body, swim, (float)Math.toRadians(80.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, swim, (float)Math.toRadians(-70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail, swim, (float)Math.toRadians(-50.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.body, swim, 0.0f, 8.0f, 0.0f, 1.0f);
        this.flap(this.body, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.lleg, walkSpeed, walkDegree * 0.1f, true, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.rleg, walkSpeed, walkDegree * 0.1f, true, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.head, walkSpeed, walkDegree * 0.1f, true, 2.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.larm, walkSpeed, walkDegree * 0.1f, true, 0.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.rarm, walkSpeed, walkDegree * 0.1f, false, 0.0f, 0.0f, limbSwing, walkAmount);
        float bodyWalkBob = -Math.abs(ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -1.5f, 1.0f, false));
        float bodySwimBob = -ACMath.walkValue(limbSwing, swimAmount, swimSpeed, 0.0f, 3.0f, false);
        this.body.rotationPointY += bodyWalkBob + bodySwimBob;
        this.lleg.rotationPointY -= bodyWalkBob;
        this.rleg.rotationPointY -= bodyWalkBob;
        this.lleg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -2.5f, 5.0f, true)) - walkAmount * 1.0f;
        this.rleg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -2.5f, 5.0f, false)) - walkAmount * 1.0f;
        this.walk(this.lleg, walkSpeed, walkDegree, false, -1.0f, 0.0f, limbSwing, walkAmount);
        this.walk(this.rleg, walkSpeed, walkDegree, true, -1.0f, 0.0f, limbSwing, walkAmount);
        this.walk(this.rarm, walkSpeed, walkDegree * 0.2f, true, -3.0f, 0.4f, limbSwing, walkAmount);
        this.walk(this.larm, walkSpeed, walkDegree * 0.2f, false, -3.0f, -0.4f, limbSwing, walkAmount);
        this.swing(this.tail, walkSpeed, walkDegree * 0.2f, false, -1.0f, -0.0f, limbSwing, walkAmount);
        this.flap(this.body, swimSpeed, swimDegree * 1.0f, true, 0.0f, 0.0f, limbSwing, swimAmount);
        this.swing(this.head, swimSpeed, swimDegree * 1.0f, false, 0.5f, 0.0f, limbSwing, swimAmount);
        this.flap(this.larm, swimSpeed, swimDegree * 2.75f, true, -0.5f, 1.5f, limbSwing, swimAmount);
        this.swing(this.larm, swimSpeed, swimDegree, true, -1.5f, 0.0f, limbSwing, swimAmount);
        this.walk(this.larm, swimSpeed, swimDegree, true, -2.0f, -0.2f, limbSwing, swimAmount);
        this.flap(this.rarm, swimSpeed, swimDegree * 2.75f, false, -3.0f, 1.5f, limbSwing, swimAmount);
        this.swing(this.rarm, swimSpeed, swimDegree, false, -1.5f, 0.0f, limbSwing, swimAmount);
        this.walk(this.rarm, swimSpeed, swimDegree, false, -4.5f, -0.2f, limbSwing, swimAmount);
        this.flap(this.tail, swimSpeed, swimDegree * 0.75f, false, -2.0f, 0.0f, limbSwing, swimAmount);
        this.walk(this.rleg, swimSpeed * 1.5f, swimDegree * 1.0f, true, 2.0f, 0.0f, limbSwing, swimAmount);
        this.walk(this.lleg, swimSpeed * 1.5f, swimDegree * 1.0f, false, 2.0f, 0.0f, limbSwing, swimAmount);
        if (entity.getAnimation() != entity.getTradingAnimation()) {
            this.body.rotateAngleX += fishPitchAmount;
            this.head.rotateAngleX += headPitchAmount;
        }
        this.head.rotateAngleY += clampedYaw;
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.tail, (Object)this.head, (Object)this.jaw, (Object)this.rarm, (Object)this.larm, (Object)this.rleg, (Object)this.lleg, (Object)this.headFins);
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.body.translateAndRotate(poseStack);
        if (arm == HumanoidArm.RIGHT) {
            this.rarm.translateAndRotate(poseStack);
        } else {
            this.larm.translateAndRotate(poseStack);
        }
        poseStack.m_252880_(0.0f, 0.65f, 0.1f);
    }
}

