/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui.book;

import com.github.alexmodguy.alexscaves.client.gui.book.BookEntry;
import com.github.alexmodguy.alexscaves.client.gui.book.PageRenderer;
import com.github.alexmodguy.alexscaves.client.model.CaveBookModel;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.CaveBookProgress;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Vector3f;

public class CaveBookScreen
extends Screen {
    private static final CaveBookModel BOOK_MODEL = new CaveBookModel();
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("alexscaves", "textures/gui/book/cave_book_model.png");
    public static final float MOUSE_LEAN_THRESHOLD = 0.75f;
    public static final int PAGE_SIZE_IN_LINES = 15;
    public static final int TEXT_COLOR = 8546881;
    public static final int TEXT_LINK_COLOR = 0x111111;
    public static final int TEXT_LINK_HOVER_COLOR = 38143;
    public static final int TEXT_LINK_LOCKED_COLOR = 13879723;
    private final CaveBookProgress caveBookProgress;
    public boolean unlockTooltip;
    private boolean incrementingPage;
    private boolean decrementingPage;
    private float prevFlipProgress;
    private float flipProgress;
    private float prevOpenBookProgress;
    private float openBookProgress;
    private int tickCount = 0;
    private float flipSpeed = 0.1f;
    private int lastTurnClickTimestamp = -1;
    private boolean hoveringPageLeft;
    private boolean hoveringPageRight;
    protected ResourceLocation prevEntryJSON = null;
    protected ResourceLocation currentEntryJSON;
    protected ResourceLocation nextEntryJSON;
    private BookEntry currentEntry;
    private BookEntry prevEntry;
    private BookEntry nextEntry;
    private int entryPageNumber = 0;
    private int lastEntryPageBeforeLinkClick = -1;
    private int closeBookForTicks;
    private PageRenderer prevLeftPageRenderer = new PageRenderer(-2);
    private PageRenderer prevRightPageRenderer = new PageRenderer(-1);
    private PageRenderer leftPageRenderer = new PageRenderer(0);
    private PageRenderer rightPageRenderer = new PageRenderer(1);
    private PageRenderer nextLeftPageRenderer = new PageRenderer(2);
    private PageRenderer nextRightPageRenderer = new PageRenderer(3);

    public CaveBookScreen(String openTo) {
        super((Component)Component.m_237115_((String)"item.alexscaves.cave_book"));
        this.caveBookProgress = CaveBookProgress.getCaveBookProgress((Player)Minecraft.m_91087_().f_91074_);
        this.currentEntryJSON = new ResourceLocation("alexscaves", openTo);
        this.resetEntry();
    }

    public CaveBookScreen() {
        this("books/root.json");
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
    }

    public void m_86600_() {
        this.prevFlipProgress = this.flipProgress;
        this.prevOpenBookProgress = this.openBookProgress;
        ++this.tickCount;
        if (this.flipProgress < 1.0f && this.openBookProgress >= 1.0f && (this.decrementingPage || this.incrementingPage)) {
            this.flipProgress = Math.min(1.0f, this.flipProgress + this.flipSpeed);
        } else {
            if (this.incrementingPage) {
                if (this.nextEntryJSON != null) {
                    this.prevEntryJSON = this.currentEntryJSON;
                    this.currentEntryJSON = this.nextEntryJSON;
                    this.nextEntryJSON = null;
                    this.nextEntry = null;
                    this.resetEntry();
                } else {
                    ++this.entryPageNumber;
                }
                this.incrementingPage = false;
                this.updatePageRenderers();
            }
            if (this.decrementingPage) {
                --this.entryPageNumber;
                if (this.entryPageNumber < 0 && this.prevEntry != null) {
                    int i = this.lastEntryPageBeforeLinkClick == -1 ? 0 : this.lastEntryPageBeforeLinkClick;
                    this.lastEntryPageBeforeLinkClick = -1;
                    this.currentEntryJSON = this.prevEntryJSON;
                    this.resetEntry();
                    this.entryPageNumber = i;
                }
                this.decrementingPage = false;
                this.updatePageRenderers();
            }
            this.flipProgress = 0.0f;
            this.prevFlipProgress = 0.0f;
        }
        if (this.isBookOpened()) {
            if (this.openBookProgress == 0.0f) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ACSoundRegistry.CAVE_BOOK_OPEN.get()), (float)1.0f));
            }
            if (this.openBookProgress < 1.0f) {
                this.openBookProgress += 0.1f;
            }
        } else {
            if (this.openBookProgress > 0.0f) {
                this.openBookProgress = Math.max(this.openBookProgress - 0.15f, 0.0f);
            }
            if (this.closeBookForTicks > 0) {
                --this.closeBookForTicks;
            }
            if (this.closeBookForTicks == 0 && this.nextEntryJSON != null) {
                this.prevEntryJSON = this.currentEntryJSON;
                this.currentEntryJSON = this.nextEntryJSON;
                this.nextEntryJSON = null;
                this.nextEntry = null;
                this.resetEntry();
            }
        }
    }

    public void resetEntry() {
        if (this.currentEntryJSON != null) {
            this.currentEntry = this.readBookEntry(this.currentEntryJSON);
            if (this.currentEntry != null) {
                this.currentEntry.init(this);
            }
        }
        this.prevEntryJSON = this.currentEntry != null && this.currentEntry.getParent() != null && !this.currentEntry.getParent().isEmpty() ? new ResourceLocation(CaveBookScreen.getBookFileDirectory() + this.currentEntry.getParent()) : null;
        if (this.prevEntryJSON != null) {
            this.prevEntry = this.readBookEntry(this.prevEntryJSON);
            if (this.prevEntry != null) {
                this.prevEntry.init(this);
            }
        }
        if (this.nextEntryJSON != null) {
            this.nextEntry = this.readBookEntry(this.nextEntryJSON);
            if (this.nextEntry != null) {
                this.nextEntry.init(this);
            }
        }
        if (this.currentEntry != null) {
            this.entryPageNumber = 0;
        }
        this.updatePageRenderers();
    }

    public void updatePageRenderers() {
        boolean flag = this.prevEntryJSON != null && this.entryPageNumber == 0;
        int pgOffsetReturningFromLink = this.lastEntryPageBeforeLinkClick != -1 && this.entryPageNumber == 0 ? this.lastEntryPageBeforeLinkClick : 0;
        this.leftPageRenderer.setEntryPageNumber(this.entryPageNumber);
        this.leftPageRenderer.setEntry(this.currentEntry);
        this.rightPageRenderer.setEntryPageNumber(this.entryPageNumber);
        this.rightPageRenderer.setEntry(this.currentEntry);
        this.prevLeftPageRenderer.setEntryPageNumber(this.entryPageNumber + pgOffsetReturningFromLink);
        this.prevLeftPageRenderer.setEntry(this.entryPageNumber == 0 && this.prevEntry != null ? this.prevEntry : this.currentEntry);
        this.prevRightPageRenderer.setEntryPageNumber(this.entryPageNumber + pgOffsetReturningFromLink);
        this.prevRightPageRenderer.setEntry(this.entryPageNumber == 0 && this.prevEntry != null ? this.prevEntry : this.currentEntry);
        this.nextLeftPageRenderer.setEntryPageNumber(this.entryPageNumber);
        this.nextLeftPageRenderer.setEntry(this.nextEntryJSON != null ? this.nextEntry : this.currentEntry);
        this.nextRightPageRenderer.setEntryPageNumber(this.entryPageNumber);
        this.nextRightPageRenderer.setEntry(this.nextEntryJSON != null ? this.nextEntry : this.currentEntry);
        if (this.nextEntryJSON != null) {
            this.nextLeftPageRenderer.enteringNewPageFlag = true;
            this.nextRightPageRenderer.enteringNewPageFlag = true;
        } else {
            this.nextLeftPageRenderer.enteringNewPageFlag = false;
            this.nextRightPageRenderer.enteringNewPageFlag = false;
        }
        if (flag) {
            this.prevLeftPageRenderer.leavingNewPageFlag = true;
            this.prevRightPageRenderer.leavingNewPageFlag = true;
        } else {
            this.prevLeftPageRenderer.leavingNewPageFlag = false;
            this.prevRightPageRenderer.leavingNewPageFlag = false;
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280120_(0, 0, this.f_96543_, this.f_96544_, -1000, -1072689136, -804253680);
        MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered((Screen)this, guiGraphics));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float fakePartialTickThatsZeroForSomeReason) {
        float partialTick = Minecraft.m_91087_().getPartialTick();
        PoseStack poseStack = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        float ageInTicks = (float)this.tickCount + partialTick;
        float openGuiAmount = Math.min(ageInTicks, 5.0f) / 5.0f;
        float invOpenGuiAmount = 1.0f - openGuiAmount;
        float openBookAmount = this.prevOpenBookProgress + (this.openBookProgress - this.prevOpenBookProgress) * partialTick;
        float bookScale = 221.0f - invOpenGuiAmount * 180.0f;
        float flip = this.prevFlipProgress + (this.flipProgress - this.prevFlipProgress) * partialTick;
        float pageAngle = (float)Math.PI * (this.incrementingPage ? 1.0f - flip : flip);
        float pageFlipBump = (float)Math.sin((double)flip * Math.PI);
        float pageUp = this.incrementingPage ? 1.0f - flip : 0.0f;
        int i = this.f_96543_ / 2;
        int j = this.f_96544_ / 2;
        float mouseLeanX = (float)(mouseX - i) / bookScale;
        float mouseLeanY = (float)(mouseY - j) / bookScale;
        this.hoveringPageLeft = mouseLeanX < -0.75f && this.canGoLeft();
        this.hoveringPageRight = mouseLeanX > 0.75f && this.canGoRight();
        poseStack.m_85836_();
        poseStack.m_252880_((float)i + invOpenGuiAmount * (float)i * 0.5f, (float)(j + 6) + 15.0f * pageFlipBump, 100.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252392_.m_252977_(50.0f * invOpenGuiAmount));
        poseStack.m_85841_(bookScale, bookScale, bookScale);
        poseStack.m_85836_();
        BOOK_MODEL.m_6973_(null, openBookAmount, pageAngle, pageUp, -20.0f * openBookAmount - 10.0f * pageFlipBump, 0.0f);
        BOOK_MODEL.mouseOver(mouseLeanX, mouseLeanY, ageInTicks, flip, this.canGoLeft(), this.canGoRight());
        BOOK_MODEL.m_7695_(poseStack, bufferSource.m_6299_(ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)BOOK_TEXTURE)), 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderBookContents(poseStack, mouseX, mouseY, partialTick);
        guiGraphics.m_280262_();
        poseStack.m_85849_();
        poseStack.m_85849_();
        if (this.currentEntry != null) {
            this.currentEntry.mouseOver(this, this.entryPageNumber, mouseLeanX, mouseLeanY);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, fakePartialTickThatsZeroForSomeReason);
        this.m_280273_(guiGraphics);
        if (this.unlockTooltip) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"book.alexscaves.page_locked_0").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"book.alexscaves.page_locked_1").m_130940_(ChatFormatting.GRAY));
            guiGraphics.m_280677_(this.f_96547_, list, Optional.empty(), mouseX - 5, mouseY - 5);
        }
    }

    private void renderBookContents(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean left = this.hoveringPageLeft || this.decrementingPage;
        boolean right = this.hoveringPageRight || this.incrementingPage;
        float flip = this.prevFlipProgress + (this.flipProgress - this.prevFlipProgress) * partialTick;
        if (left) {
            this.renderForPageType(this.leftPageRenderer, 2, poseStack, mouseX, mouseY, partialTick);
        } else if (flip < 0.9f) {
            this.renderForPageType(this.leftPageRenderer, 0, poseStack, mouseX, mouseY, partialTick);
        }
        if (right) {
            this.renderForPageType(this.rightPageRenderer, 3, poseStack, mouseX, mouseY, partialTick);
        } else if (flip < 0.9f) {
            this.renderForPageType(this.rightPageRenderer, 1, poseStack, mouseX, mouseY, partialTick);
        }
        if (this.incrementingPage) {
            this.renderForPageType(this.nextLeftPageRenderer, 2, poseStack, mouseX, mouseY, partialTick);
            if (flip > 0.1f) {
                this.renderForPageType(this.nextRightPageRenderer, 1, poseStack, mouseX, mouseY, partialTick);
            }
        }
        if (this.decrementingPage) {
            this.renderForPageType(this.prevRightPageRenderer, 3, poseStack, mouseX, mouseY, partialTick);
            if (flip > 0.1f) {
                this.renderForPageType(this.prevLeftPageRenderer, 0, poseStack, mouseX, mouseY, partialTick);
            }
        }
    }

    private void renderForPageType(PageRenderer contents, int kind, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        poseStack.m_85836_();
        BOOK_MODEL.translateToPage(poseStack, Math.min(kind, 2));
        switch (kind) {
            case 0: {
                poseStack.m_252880_(-0.1f, -0.1885f, -0.005f);
                break;
            }
            case 1: {
                poseStack.m_252880_(-0.725f, -0.1885f, -0.005f);
                break;
            }
            case 2: {
                poseStack.m_252880_(-0.0375f, -0.015f, -0.01f);
                break;
            }
            case 3: {
                poseStack.m_252880_(-0.7125f, 0.0054f, -0.005f);
            }
        }
        poseStack.m_252880_(0.75f, 0.0f, 0.4f);
        poseStack.m_85841_(0.005f, 0.005f, 0.005f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (kind == 3) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        poseStack.m_85841_(1.0f, 1.0f, 0.01f);
        contents.renderPage(this, poseStack, mouseX, mouseY, partialTick, kind >= 2);
        poseStack.m_85849_();
    }

    private boolean isBookOpened() {
        return this.tickCount >= 12 && this.currentEntry != null && this.closeBookForTicks <= 0;
    }

    public boolean canGoLeft() {
        return this.isBookOpened() && (this.entryPageNumber > 0 || this.prevEntryJSON != null);
    }

    public boolean canGoRight() {
        return this.isBookOpened() && this.entryPageNumber + 1 < this.currentEntry.getPageCount();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int i = this.f_96543_ / 2;
        float distFromMiddleX = (float)((mouseX - (double)i) / 220.0);
        boolean prev = super.m_6375_(mouseX, mouseY, button);
        if (!prev) {
            if (this.currentEntry != null && this.currentEntry.consumeMouseClick(this)) {
                return true;
            }
            this.flipSpeed = this.tickCount - this.lastTurnClickTimestamp < 8 ? 0.3f : 0.1f;
            this.lastTurnClickTimestamp = this.tickCount;
            if (!this.decrementingPage && !this.incrementingPage) {
                if (distFromMiddleX < -0.75f && this.canGoLeft()) {
                    this.decrementingPage = true;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ACSoundRegistry.CAVE_BOOK_TURN.get()), (float)1.0f));
                    return true;
                }
                if (distFromMiddleX > 0.75f && this.canGoRight()) {
                    this.incrementingPage = true;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ACSoundRegistry.CAVE_BOOK_TURN.get()), (float)1.0f));
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Nullable
    protected BookEntry readBookEntry(ResourceLocation res) {
        BookEntry page;
        block3: {
            Optional resource = null;
            page = null;
            try {
                resource = Minecraft.m_91087_().m_91098_().m_213713_(res);
                if (resource.isPresent()) {
                    BufferedReader inputstream = ((Resource)resource.get()).m_215508_();
                    page = BookEntry.deserialize(inputstream);
                }
            }
            catch (IOException e1) {
                if (e1 instanceof AccessDeniedException) break block3;
                e1.printStackTrace();
            }
        }
        return page;
    }

    public CaveBookProgress getCaveBookProgress() {
        return this.caveBookProgress;
    }

    public int getEntryPageNumber() {
        return this.entryPageNumber;
    }

    public static String getBookFileDirectory() {
        return "alexscaves:books/";
    }

    public boolean attemptChangePage(ResourceLocation changePageTo, boolean goingForwards) {
        if (!this.currentEntryJSON.equals((Object)changePageTo)) {
            this.lastEntryPageBeforeLinkClick = this.entryPageNumber;
        }
        if (goingForwards) {
            this.prevEntryJSON = this.currentEntryJSON;
        }
        this.nextEntryJSON = changePageTo;
        if (goingForwards) {
            this.closeBookForTicks = 10;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ACSoundRegistry.CAVE_BOOK_CLOSE.get()), (float)1.0f));
        }
        return true;
    }

    public static void fixLighting() {
        Vector3f light0 = new Vector3f(1.0f, 1.0f, -1.0f);
        Vector3f light1 = new Vector3f(1.0f, 1.0f, -1.0f);
        RenderSystem.setShaderLights((Vector3f)light0, (Vector3f)light1);
    }

    public int getEntryVisiblity(String linkTo) {
        ResourceLocation resourceLocation = new ResourceLocation(CaveBookScreen.getBookFileDirectory() + linkTo);
        BookEntry dummyEntry = this.readBookEntry(resourceLocation);
        int visiblity = 0;
        if (dummyEntry != null) {
            visiblity = dummyEntry.getVisibility(this);
        }
        if (visiblity != 2 && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_()) {
            visiblity = 0;
        }
        return visiblity;
    }
}

