/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.lib.Version;
import mekanism.tools.common.MobEquipmentHelper;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.material.BaseMekanismMaterial;
import mekanism.tools.common.registries.ToolsCreativeTabs;
import mekanism.tools.common.registries.ToolsItems;
import mekanism.tools.common.registries.ToolsRecipeSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismtools")
public class MekanismTools
implements IModModule {
    public static final String MODID = "mekanismtools";
    public static MekanismTools instance;
    public final Version versionNumber;

    public MekanismTools() {
        instance = this;
        Mekanism.addModule((IModModule)instance);
        MekanismToolsConfig.registerConfigs(ModLoadingContext.get());
        MinecraftForge.EVENT_BUS.addListener(MobEquipmentHelper::onLivingSpecialSpawn);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        ToolsItems.ITEMS.register(modEventBus);
        ToolsCreativeTabs.CREATIVE_TABS.register(modEventBus);
        ToolsRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            MekanismModConfig mekConfig = (MekanismModConfig)config;
            mekConfig.clearCache(configEvent);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ToolsTags.init());
        this.registerTiers(MekanismToolsConfig.tools.bronze, MekanismToolsConfig.tools.lapisLazuli, MekanismToolsConfig.tools.osmium, MekanismToolsConfig.tools.steel, MekanismToolsConfig.tools.refinedGlowstone, MekanismToolsConfig.tools.refinedObsidian);
        Mekanism.logger.info("Loaded 'Mekanism: Tools' module.");
    }

    private void registerTiers(BaseMekanismMaterial ... tiers) {
        HashMultimap vanillaTiers = HashMultimap.create();
        for (Tiers tiers2 : Tiers.values()) {
            vanillaTiers.put((Object)tiers2.m_6604_(), (Object)tiers2);
        }
        for (BaseMekanismMaterial baseMekanismMaterial : tiers) {
            int level = baseMekanismMaterial.m_6604_();
            Collection equivalent = vanillaTiers.get((Object)level);
            Collection vanillaNext = vanillaTiers.get((Object)(level + 1));
            TierSortingRegistry.registerTier((Tier)baseMekanismMaterial, (ResourceLocation)MekanismTools.rl(baseMekanismMaterial.getRegistryPrefix()), new ArrayList(equivalent), new ArrayList(vanillaNext));
        }
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Tools";
    }

    public void resetClient() {
    }
}

