/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InfusionRecipe
implements ISpecialRecipe,
IInfusionRecipe {
    public static final int RECIPE_SIZE = 9;
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final boolean transferNBT;
    private BiFunction<Integer, ItemStack, ItemStack> transformer;

    public InfusionRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output, boolean transferNBT) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.transferNBT = transferNBT;
    }

    public ItemStack assemble(IItemHandler inventory, RegistryAccess access) {
        CompoundTag tag;
        ItemStack stack = inventory.getStackInSlot(0);
        ItemStack result = this.output.m_41777_();
        if (this.transferNBT && (tag = stack.m_41783_()) != null) {
            result.m_41751_(tag.m_6426_());
            return result;
        }
        return result;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess access) {
        return this.assemble((IItemHandler)new InvWrapper(inventory), access);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.INFUSION.get();
    }

    public RecipeType<? extends IInfusionRecipe> m_6671_() {
        return (RecipeType)ModRecipeTypes.INFUSION.get();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack altarStack = inventory.getStackInSlot(0);
        return !this.inputs.isEmpty() && ((Ingredient)this.inputs.get(0)).test(altarStack) && super.matches(inventory);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public NonNullList<ItemStack> getRemainingItems(IItemHandler inventory) {
        NonNullList remaining = super.getRemainingItems(inventory);
        if (this.transformer != null) {
            boolean[] used = new boolean[remaining.size()];
            block0: for (int i = 0; i < remaining.size(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                for (int j = 0; j < this.inputs.size(); ++j) {
                    Ingredient input = (Ingredient)this.inputs.get(j);
                    if (used[j] || !input.test(stack)) continue;
                    ItemStack ingredient = this.transformer.apply(j, stack);
                    used[j] = true;
                    remaining.set(i, (Object)ingredient);
                    continue block0;
                }
            }
        }
        return remaining;
    }

    public void setTransformer(BiFunction<Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        public InfusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            JsonObject input = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)input));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i + 1, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            boolean transferNBT = GsonHelper.m_13855_((JsonObject)json, (String)"transfer_nbt", (boolean)false);
            return new InfusionRecipe(recipeId, (NonNullList<Ingredient>)inputs, result, transferNBT);
        }

        public InfusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            boolean transferNBT = buffer.readBoolean();
            return new InfusionRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, transferNBT);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfusionRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.writeBoolean(recipe.transferNBT);
        }
    }
}

