/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.client.gui.screen.ProgramEditorScreen;
import ca.teamdman.sfm.client.gui.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.gui.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMClientProgramEditorConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ProgramEditorConfigScreen
extends Screen {
    private final SFMClientProgramEditorConfig config;
    private final ProgramEditorScreen parent;
    private final Runnable closeCallback;
    private Button lineNumbersOnButton;
    private Button lineNumbersOffButton;
    private Button intellisenseOffButton;
    private Button intellisenseBasicButton;
    private Button intellisenseAdvancedButton;

    public ProgramEditorConfigScreen(ProgramEditorScreen parent, SFMClientProgramEditorConfig config, Runnable closeCallback) {
        super((Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_SCREEN_TITLE.getComponent());
        this.config = config;
        this.parent = parent;
        this.closeCallback = closeCallback;
    }

    public void m_7379_() {
        SFMScreenChangeHelpers.popScreen();
        this.closeCallback.run();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        int y = this.f_96544_ / 2 - 65;
        int x = this.f_96543_ / 2 - 150;
        graphics.m_280430_(this.f_96547_, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_LINE_NUMBERS.getComponent(), x, y, 0xFFFFFF);
        graphics.m_280430_(this.f_96547_, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE.getComponent(), x, y + 50, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 100;
        int buttonHeight = 20;
        int x = this.f_96543_ / 2 - 3 * buttonWidth / 2 - 10;
        int y = this.f_96544_ / 2 - 50;
        int spacing = 50;
        int buttonSpacing = 10;
        this.lineNumbersOnButton = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y).setSize(buttonWidth, buttonHeight).setText(CommonComponents.f_130653_).setOnPress(button -> this.setLineNumbers(true)).build();
        this.lineNumbersOffButton = new SFMButtonBuilder().setPosition(x, y).setSize(buttonWidth, buttonHeight).setText(CommonComponents.f_130654_).setOnPress(button -> this.setLineNumbers(false)).build();
        this.m_142416_((GuiEventListener)this.lineNumbersOnButton);
        this.m_142416_((GuiEventListener)this.lineNumbersOffButton);
        this.intellisenseOffButton = new SFMButtonBuilder().setPosition(x, y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_OFF).setOnPress(button -> this.setIntellisenseLevel(SFMClientProgramEditorConfig.IntellisenseLevel.OFF)).build();
        this.intellisenseBasicButton = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_BASIC).setOnPress(button -> this.setIntellisenseLevel(SFMClientProgramEditorConfig.IntellisenseLevel.BASIC)).build();
        this.intellisenseAdvancedButton = new SFMButtonBuilder().setPosition(x + 2 * (buttonWidth + buttonSpacing), y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_ADVANCED).setOnPress(button -> this.setIntellisenseLevel(SFMClientProgramEditorConfig.IntellisenseLevel.ADVANCED)).build();
        this.m_142416_((GuiEventListener)this.intellisenseOffButton);
        this.m_142416_((GuiEventListener)this.intellisenseBasicButton);
        this.m_142416_((GuiEventListener)this.intellisenseAdvancedButton);
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 100, this.f_96544_ - 50).setSize(200, 20).setText(CommonComponents.f_130655_).setOnPress(button -> this.m_7379_()).build());
        this.updateButtonStates();
    }

    private void setLineNumbers(boolean show) {
        this.config.showLineNumbers.set((Object)show);
        this.updateButtonStates();
    }

    private void setIntellisenseLevel(SFMClientProgramEditorConfig.IntellisenseLevel level) {
        this.config.intellisenseLevel.set((Object)level);
        this.updateButtonStates();
        this.parent.onIntellisensePreferenceChanged();
    }

    private void updateButtonStates() {
        this.lineNumbersOnButton.f_93623_ = (Boolean)this.config.showLineNumbers.get() == false;
        this.lineNumbersOffButton.f_93623_ = (Boolean)this.config.showLineNumbers.get();
        this.intellisenseOffButton.f_93623_ = this.config.intellisenseLevel.get() != SFMClientProgramEditorConfig.IntellisenseLevel.OFF;
        this.intellisenseBasicButton.f_93623_ = this.config.intellisenseLevel.get() != SFMClientProgramEditorConfig.IntellisenseLevel.BASIC;
        this.intellisenseAdvancedButton.f_93623_ = this.config.intellisenseLevel.get() != SFMClientProgramEditorConfig.IntellisenseLevel.ADVANCED;
    }
}

