/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46.batching;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.MagicNumbers;
import net.roguelogix.quartz.internal.MultiBuffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.DynamicMatrixManager;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl46.batching.GL46DrawBatch;
import net.roguelogix.quartz.internal.gl46.batching.GL46DrawChunk;
import net.roguelogix.quartz.internal.gl46.batching.GL46Instance;
import org.joml.Matrix4fc;
import org.joml.Vector3ic;

@NonnullDefault
public class GL46InstanceManager {
    final GL46DrawBatch drawBatch;
    private final boolean autoDelete;
    private int instancesAllocated = 8;
    MultiBuffer.Allocation instanceDataAlloc;
    private InternalMesh staticMesh;
    private InternalMesh.Manager.TrackedMesh trackedMesh;
    private final Consumer<InternalMesh.Manager.TrackedMesh> meshBuildCallback;
    final ReferenceArrayList<GL46DrawChunk> drawChunks = new ReferenceArrayList();
    final ReferenceArrayList<WeakReference<GL46Instance>> instances = new ReferenceArrayList();
    final FastArraySet<WeakReference<GL46Instance>> dirtyInstances = new FastArraySet();

    public GL46InstanceManager(GL46DrawBatch drawBatch, InternalMesh mesh, boolean autoDelete) {
        this.drawBatch = drawBatch;
        this.autoDelete = autoDelete;
        drawBatch.instanceBatches.add((Object)this);
        WeakReference<GL46InstanceManager> ref = new WeakReference<GL46InstanceManager>(this);
        this.meshBuildCallback = ignored -> {
            GL46InstanceManager manager = (GL46InstanceManager)ref.get();
            if (manager != null) {
                manager.onRebuild();
            }
        };
        this.instanceDataAlloc = drawBatch.instanceDataBuffer.alloc(this.instancesAllocated * 128, 128);
        this.updateMesh(mesh);
    }

    void delete() {
        while (!this.instances.isEmpty()) {
            WeakReference lastInstanceRef = (WeakReference)this.instances.peek(0);
            GL46Instance lastInstance = (GL46Instance)lastInstanceRef.get();
            if (lastInstance == null) {
                this.instances.pop();
                continue;
            }
            this.removeInstance(lastInstance.location);
        }
        this.drawChunks.forEach(this.drawBatch::removeDrawChunk);
        this.drawChunks.clear();
        this.drawBatch.instanceManagers.remove((Object)this.staticMesh, (Object)this);
        this.drawBatch.instanceBatches.remove((Object)this);
        this.drawBatch.setIndirectInfoDirty();
        this.trackedMesh.removeBuildCallback(this.meshBuildCallback);
        this.instanceDataAlloc.free();
    }

    void updateMesh(Mesh quartzMesh) {
        if (!(quartzMesh instanceof InternalMesh)) {
            return;
        }
        InternalMesh mesh = (InternalMesh)quartzMesh;
        if (this.trackedMesh != null) {
            this.trackedMesh.removeBuildCallback(this.meshBuildCallback);
        }
        this.staticMesh = mesh;
        this.trackedMesh = QuartzCore.INSTANCE.meshManager.getMeshInfo(mesh);
        if (this.trackedMesh == null) {
            throw new IllegalArgumentException("Unable to find mesh in mesh registry");
        }
        this.onRebuild();
        this.trackedMesh.addBuildCallback(this.meshBuildCallback);
    }

    private void onRebuild() {
        this.drawChunks.forEach(this.drawBatch::removeDrawChunk);
        this.drawChunks.clear();
        for (RenderType renderType : this.trackedMesh.usedRenderTypes()) {
            InternalMesh.Manager.TrackedMesh.Component component = this.trackedMesh.renderTypeComponent(renderType);
            if (component == null) continue;
            GL46DrawChunk newChunk = new GL46DrawChunk(this, renderType, component);
            this.drawChunks.add((Object)newChunk);
            this.drawBatch.addDrawChunk(newChunk);
        }
        this.setDirty();
        this.drawBatch.setIndirectInfoDirty();
    }

    @Nullable
    GL46Instance createInstance(Vector3ic position, @Nullable DynamicMatrix dynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable AABB aabb) {
        DynamicMatrixManager.Matrix castedMatrix;
        block6: {
            block5: {
                if (dynamicMatrix == null) {
                    dynamicMatrix = this.drawBatch.IDENTITY_DYNAMIC_MATRIX;
                }
                if (!(dynamicMatrix instanceof DynamicMatrixManager.Matrix)) break block5;
                castedMatrix = (DynamicMatrixManager.Matrix)dynamicMatrix;
                if (this.drawBatch.dynamicMatrixManager.owns(dynamicMatrix)) break block6;
            }
            return null;
        }
        if (staticMatrix == null) {
            staticMatrix = MagicNumbers.IDENTITY_MATRIX;
        }
        return this.createInstance(position, castedMatrix, staticMatrix, aabb);
    }

    GL46Instance createInstance(Vector3ic position, @Nullable DynamicMatrixManager.Matrix dynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable AABB aabb) {
        GL46Instance instance = new GL46Instance(this, this.instances.size());
        instance.updatePosition(position);
        instance.updateDynamicMatrix(dynamicMatrix);
        instance.updateStaticMatrix(staticMatrix);
        instance.updateAABB(aabb);
        this.instances.add(instance.selfWeakRef);
        this.setDirty();
        this.drawBatch.setIndirectInfoDirty();
        return instance;
    }

    void removeInstance(GL46Instance.Location location) {
        if (location.location == -1) {
            return;
        }
        if (this.instances.isEmpty()) {
            return;
        }
        WeakReference lastInstanceRef = (WeakReference)this.instances.pop();
        this.setDirty();
        this.drawBatch.setIndirectInfoDirty();
        if (this.instances.size() == location.location) {
            location.location = -1;
            this.dirtyInstances.remove((Object)lastInstanceRef);
            if (this.instances.isEmpty() && this.autoDelete) {
                this.delete();
            }
            return;
        }
        GL46Instance lastInstance = (GL46Instance)lastInstanceRef.get();
        if (lastInstance == null) {
            location.location = -1;
            this.dirtyInstances.remove((Object)lastInstanceRef);
            return;
        }
        lastInstance.location.location = location.location;
        WeakReference removed = (WeakReference)this.instances.set(location.location, (Object)lastInstanceRef);
        location.location = -1;
        this.dirtyInstances.remove((Object)removed);
        lastInstance.setDirty();
    }

    void setDirty() {
        this.drawBatch.dirtyBatches.add((Object)this);
    }

    public int instanceCount() {
        return this.instances.size();
    }

    public int baseInstance(int frame) {
        return this.instanceDataAlloc.allocation(frame).offset() / 128;
    }

    public boolean writeUpdates() {
        if (this.dirtyInstances.isEmpty()) {
            return false;
        }
        if (this.instanceCount() > this.instancesAllocated || this.instanceCount() > 16 && this.instanceCount() <= this.instancesAllocated / 4) {
            int newAllocCount = this.instancesAllocated;
            do {
                int n = newAllocCount = this.instanceCount() > newAllocCount ? newAllocCount * 2 : newAllocCount / 2;
            } while (this.instanceCount() > newAllocCount || this.instanceCount() > 16 && this.instanceCount() <= newAllocCount / 4);
            this.instanceDataAlloc = this.drawBatch.instanceDataBuffer.realloc(this.instanceDataAlloc, newAllocCount * 128, 128, false);
            this.instancesAllocated = newAllocCount;
            for (WeakReference instanceRef : this.instances) {
                GL46Instance instance = (GL46Instance)instanceRef.get();
                if (instance == null) continue;
                instance.setDirty();
            }
        }
        for (int i = 0; i < this.dirtyInstances.size(); ++i) {
            WeakReference dirtyInstanceRef = (WeakReference)this.dirtyInstances.get(i);
            GL46Instance instance = (GL46Instance)dirtyInstanceRef.get();
            if (instance != null && instance.write()) continue;
            this.dirtyInstances.remove((Object)dirtyInstanceRef);
            if (this.dirtyInstances.isEmpty()) break;
            --i;
        }
        return !this.dirtyInstances.isEmpty();
    }
}

