/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.roguelogix.phosphophyllite.util.Util;
import net.roguelogix.quartz.internal.gl33.BrokenMacDriverWorkaroundFragmentShader;
import net.roguelogix.quartz.internal.util.VertexFormatOutput;
import org.lwjgl.opengl.ARBSeparateShaderObjects;
import org.lwjgl.opengl.GL33C;

public class GL33FeedbackPrograms {
    public static final ResourceLocation shaderLocation = new ResourceLocation("quartz", "shaders/gl33/transform_feedback.vert");
    public static final ResourceLocation postShaderLocation = new ResourceLocation("quartz", "shaders/gl33/light_post_pass.vert");
    private static int vertexShader;
    private static final Reference2IntMap<VertexFormatOutput> programs;
    private static int postShader;
    private static final Reference2ReferenceMap<VertexFormatOutput, IntIntPair> postPrograms;
    private static final Object2ObjectMap<String, BiConsumer<Integer, Integer>> varyingSetupFunctions;

    public static void startup() {
        StringBuilder extensionsBuilder = new StringBuilder();
        extensionsBuilder.append("#version 330 core\n");
        extensionsBuilder.append("#line 1 1\n");
        StringBuilder prependBuilder = new StringBuilder();
        prependBuilder.append("#line 0 2\n");
        prependBuilder.append("#define QUARTZ_INSERT_DEFINES\n");
        prependBuilder.append("#define POSITION_LOCATION 0\n");
        prependBuilder.append("#define COLOR_LOCATION 1\n");
        prependBuilder.append("#define TEX_COORD_LOCATION 2\n");
        prependBuilder.append("#define NORMAL_LOCATION 3\n");
        prependBuilder.append("#define WORLD_POSITION_LOCATION 4\n");
        prependBuilder.append("#define DYNAMIC_MATRIX_ID_LOCATION 5\n");
        prependBuilder.append("#define STATIC_MATRIX_LOCATION 8\n");
        prependBuilder.append("#define STATIC_NORMAL_MATRIX_LOCATION 12\n");
        String shaderCode = Util.readResourceLocation((ResourceLocation)shaderLocation);
        if (shaderCode == null) {
            throw new IllegalStateException("Failed to load shader code for " + shaderLocation);
        }
        vertexShader = GL33C.glCreateShader((int)35633);
        GL33C.glShaderSource((int)vertexShader, (CharSequence[])new CharSequence[]{extensionsBuilder, prependBuilder, shaderCode});
        GL33C.glCompileShader((int)vertexShader);
        if (GL33C.glGetShaderi((int)vertexShader, (int)35713) != 1) {
            String infoLog = GL33C.glGetShaderInfoLog((int)vertexShader);
            GL33C.glDeleteShader((int)vertexShader);
            throw new IllegalStateException("Feedback shader compilation failed for " + shaderLocation + "\n" + infoLog + "\n");
        }
        String postShaderCode = Util.readResourceLocation((ResourceLocation)postShaderLocation);
        if (postShaderCode == null) {
            throw new IllegalStateException("Failed to load shader code for " + postShaderLocation);
        }
        postShader = GL33C.glCreateShader((int)35633);
        GL33C.glShaderSource((int)postShader, (CharSequence)postShaderCode);
        GL33C.glCompileShader((int)postShader);
        if (GL33C.glGetShaderi((int)postShader, (int)35713) != 1) {
            String infoLog = GL33C.glGetShaderInfoLog((int)postShader);
            GL33C.glDeleteShader((int)postShader);
            GL33C.glDeleteShader((int)vertexShader);
            throw new IllegalStateException("Feedback shader compilation failed for " + postShaderLocation + "\n" + infoLog + "\n");
        }
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85811_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85812_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85813_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85814_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85815_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_166851_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85816_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85817_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85818_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85819_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85820_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85821_));
        GL33FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85822_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85811_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85812_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85813_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85814_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85815_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_166851_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85816_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85817_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85818_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85819_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85820_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85821_));
        GL33FeedbackPrograms.getPostProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85822_));
    }

    public static void shutdown() {
        GL33C.glDeleteShader((int)vertexShader);
        vertexShader = 0;
        for (Reference2IntMap.Entry value : programs.reference2IntEntrySet()) {
            GL33C.glDeleteProgram((int)value.getIntValue());
        }
        programs.clear();
        GL33C.glDeleteShader((int)postShader);
        postShader = 0;
        for (Reference2IntMap.Entry value : postPrograms.reference2ReferenceEntrySet()) {
            GL33C.glDeleteProgram((int)((IntIntPair)value.getValue()).firstInt());
        }
        postPrograms.clear();
    }

    public static void reload() {
        GL33FeedbackPrograms.shutdown();
        GL33FeedbackPrograms.startup();
    }

    private static int createProgramForFormat(VertexFormatOutput outputFormat) {
        int vertexProgram = GL33C.glCreateProgram();
        GL33C.glAttachShader((int)vertexProgram, (int)vertexShader);
        GL33C.glAttachShader((int)vertexProgram, (int)BrokenMacDriverWorkaroundFragmentShader.bullshitFragShaderBecauseApple());
        GL33C.glTransformFeedbackVaryings((int)vertexProgram, (CharSequence[])outputFormat.varyings(), (int)35980);
        ARBSeparateShaderObjects.glProgramParameteri((int)vertexProgram, (int)33368, (int)1);
        GL33C.glLinkProgram((int)vertexProgram);
        if (GL33C.glGetProgrami((int)vertexProgram, (int)35714) != 1) {
            String infoLog = GL33C.glGetProgramInfoLog((int)vertexProgram);
            GL33C.glDeleteProgram((int)vertexProgram);
            throw new IllegalStateException("Feedback program link failed for " + outputFormat.format() + "\n" + infoLog + "\n");
        }
        GL33C.glDetachShader((int)vertexProgram, (int)BrokenMacDriverWorkaroundFragmentShader.bullshitFragShaderBecauseApple());
        GL33C.glDetachShader((int)vertexProgram, (int)vertexShader);
        int UBOLocation = GL33C.glGetUniformBlockIndex((int)vertexProgram, (CharSequence)"MainUBO");
        GL33C.glUniformBlockBinding((int)vertexProgram, (int)UBOLocation, (int)0);
        GL33C.glUseProgram((int)vertexProgram);
        int chunkIndexTextureLocation = GL33C.glGetUniformLocation((int)vertexProgram, (CharSequence)"intermediateLightChunkIndexLookup");
        GL33C.glUniform1i((int)chunkIndexTextureLocation, (int)1);
        GL33C.glUseProgram((int)0);
        return vertexProgram;
    }

    private static IntIntPair createPostProgramForFormat(VertexFormatOutput outputFormat) {
        int vertexProgram = GL33C.glCreateProgram();
        GL33C.glAttachShader((int)vertexProgram, (int)postShader);
        GL33C.glAttachShader((int)vertexProgram, (int)BrokenMacDriverWorkaroundFragmentShader.bullshitFragShaderBecauseApple());
        GL33C.glTransformFeedbackVaryings((int)vertexProgram, (CharSequence[])outputFormat.varyings(), (int)35980);
        ARBSeparateShaderObjects.glProgramParameteri((int)vertexProgram, (int)33368, (int)1);
        GL33C.glLinkProgram((int)vertexProgram);
        if (GL33C.glGetProgrami((int)vertexProgram, (int)35714) != 1) {
            String infoLog = GL33C.glGetProgramInfoLog((int)vertexProgram);
            GL33C.glDeleteProgram((int)vertexProgram);
            throw new IllegalStateException("Feedback program link failed for " + outputFormat.format() + "\n" + infoLog + "\n");
        }
        GL33C.glDetachShader((int)vertexProgram, (int)BrokenMacDriverWorkaroundFragmentShader.bullshitFragShaderBecauseApple());
        GL33C.glDetachShader((int)vertexProgram, (int)postShader);
        int UBOLocation = GL33C.glGetUniformBlockIndex((int)vertexProgram, (CharSequence)"MainUBO");
        GL33C.glUniformBlockBinding((int)vertexProgram, (int)UBOLocation, (int)0);
        GL33C.glUseProgram((int)vertexProgram);
        for (int i = 0; i < 6; ++i) {
            int chunkIndexTextureLocation = GL33C.glGetUniformLocation((int)vertexProgram, (CharSequence)("intermediateLightDataTexture[" + i + "]"));
            GL33C.glUniform1i((int)chunkIndexTextureLocation, (int)(2 + i));
        }
        GL33C.glUseProgram((int)0);
        return new IntIntImmutablePair(vertexProgram, GL33C.glGetUniformLocation((int)vertexProgram, (CharSequence)"activeArrayLayer"));
    }

    public static int getProgramForOutputFormat(VertexFormatOutput formatOutput) {
        return programs.computeIfAbsent((Object)formatOutput, GL33FeedbackPrograms::createProgramForFormat);
    }

    public static IntIntPair getPostProgramForOutputFormat(VertexFormatOutput formatOutput) {
        return (IntIntPair)postPrograms.computeIfAbsent((Object)formatOutput, GL33FeedbackPrograms::createPostProgramForFormat);
    }

    public static void setupVAOForPostProgramOutputFormat(VertexFormatOutput formatOutput) {
        ImmutableList elements = formatOutput.format().m_86023_();
        int stride = formatOutput.vertexSize();
        int offset = 0;
        for (int i = 0; i < elements.size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            String outputName = VertexFormatOutput.outputName(element);
            if (element.m_86048_() == VertexFormatElement.Usage.PADDING) {
                ++offset;
                continue;
            }
            BiConsumer setupFunc = (BiConsumer)varyingSetupFunctions.get((Object)outputName);
            setupFunc.accept(stride, offset);
            offset += element.m_86050_();
        }
    }

    static {
        programs = new Reference2IntArrayMap();
        postPrograms = new Reference2ReferenceArrayMap();
        varyingSetupFunctions = new Object2ObjectArrayMap();
        varyingSetupFunctions.put((Object)"positionOutput", (stride, offset) -> {
            GL33C.glEnableVertexAttribArray((int)0);
            GL33C.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)offset.intValue());
        });
        varyingSetupFunctions.put((Object)"normalOutput", (stride, offset) -> {
            GL33C.glEnableVertexAttribArray((int)1);
            GL33C.glVertexAttribPointer((int)1, (int)3, (int)5120, (boolean)true, (int)stride, (long)offset.intValue());
        });
        varyingSetupFunctions.put((Object)"colorOutput", (stride, offset) -> {
            GL33C.glEnableVertexAttribArray((int)2);
            GL33C.glVertexAttribIPointer((int)2, (int)1, (int)5125, (int)stride, (long)offset.intValue());
        });
        varyingSetupFunctions.put((Object)"textureOutput", (stride, offset) -> {
            GL33C.glEnableVertexAttribArray((int)3);
            GL33C.glVertexAttribPointer((int)3, (int)2, (int)5126, (boolean)false, (int)stride, (long)offset.intValue());
        });
        varyingSetupFunctions.put((Object)"overlayOutput", (stride, offset) -> {
            GL33C.glEnableVertexAttribArray((int)4);
            GL33C.glVertexAttribIPointer((int)4, (int)1, (int)5125, (int)stride, (long)offset.intValue());
        });
        varyingSetupFunctions.put((Object)"lightmapOutput", (stride, offset) -> {
            GL33C.glEnableVertexAttribArray((int)5);
            GL33C.glVertexAttribIPointer((int)5, (int)1, (int)5125, (int)stride, (long)offset.intValue());
        });
    }
}

