/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33;

import net.minecraft.resources.ResourceLocation;
import net.roguelogix.phosphophyllite.util.Util;
import net.roguelogix.quartz.internal.gl33.BrokenMacDriverWorkaroundFragmentShader;
import org.lwjgl.opengl.ARBSeparateShaderObjects;
import org.lwjgl.opengl.GL33C;

public class GL33ComputePrograms {
    private static int dynamicMatrixProgram;

    private static int createProgram(String path, String ... outputs) {
        int shader = GL33C.glCreateShader((int)35633);
        GL33C.glShaderSource((int)shader, (CharSequence)Util.readResourceLocation((ResourceLocation)new ResourceLocation("quartz", path)));
        GL33C.glCompileShader((int)shader);
        if (GL33C.glGetShaderi((int)shader, (int)35713) != 1) {
            String infoLog = GL33C.glGetShaderInfoLog((int)shader);
            GL33C.glDeleteShader((int)shader);
            throw new IllegalStateException("Feedback shader compilation failed for " + path + "\n" + infoLog + "\n");
        }
        int program = GL33C.glCreateProgram();
        GL33C.glAttachShader((int)program, (int)shader);
        GL33C.glAttachShader((int)program, (int)BrokenMacDriverWorkaroundFragmentShader.bullshitFragShaderBecauseApple());
        GL33C.glTransformFeedbackVaryings((int)program, (CharSequence[])outputs, (int)35980);
        ARBSeparateShaderObjects.glProgramParameteri((int)program, (int)33368, (int)1);
        GL33C.glLinkProgram((int)program);
        if (GL33C.glGetProgrami((int)program, (int)35714) != 1) {
            String infoLog = GL33C.glGetProgramInfoLog((int)program);
            GL33C.glDeleteProgram((int)program);
            throw new IllegalStateException("Compute program link failed for " + path + "\n" + infoLog + "\n");
        }
        GL33C.glDetachShader((int)program, (int)BrokenMacDriverWorkaroundFragmentShader.bullshitFragShaderBecauseApple());
        GL33C.glDetachShader((int)program, (int)shader);
        GL33C.glDeleteShader((int)shader);
        return program;
    }

    public static void startup() {
        dynamicMatrixProgram = GL33ComputePrograms.createProgram("shaders/gl33/dynamic_matrix.vert", "modelMatrixOut", "normalMatrixOut", "worldPositionOut", "dynamicMatrixIDOut");
        GL33C.glUseProgram((int)dynamicMatrixProgram);
        int dynamicMatricesLocation = GL33C.glGetUniformLocation((int)dynamicMatrixProgram, (CharSequence)"dynamicMatrices");
        GL33C.glUniform1i((int)dynamicMatricesLocation, (int)0);
        GL33C.glUseProgram((int)0);
    }

    public static void shutdown() {
        GL33C.glDeleteProgram((int)dynamicMatrixProgram);
        dynamicMatrixProgram = 0;
    }

    public static int dynamicMatrixProgram() {
        return dynamicMatrixProgram;
    }
}

