/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.filtering;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.AndGridFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.CraftableGridFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.FilterGridFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.ModGridFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.NameGridFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.OrGridFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.TagGridFilter;
import com.refinedmods.refinedstorage.screen.grid.filtering.TooltipGridFilter;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class GridFilterParser {
    private GridFilterParser() {
    }

    public static Predicate<IGridStack> getFilters(@Nullable IGrid grid, String query, List<IFilter> filters) {
        List<Predicate<IGridStack>> gridFilters;
        String[] orParts = query.split("\\|");
        if (orParts.length == 1) {
            gridFilters = GridFilterParser.getFilters(orParts[0]);
        } else {
            LinkedList<Predicate<IGridStack>> orPartFilters = new LinkedList<Predicate<IGridStack>>();
            for (String orPart : orParts) {
                orPartFilters.add(AndGridFilter.of(GridFilterParser.getFilters(orPart)));
            }
            gridFilters = new LinkedList<Predicate<IGridStack>>();
            gridFilters.add(OrGridFilter.of(orPartFilters));
        }
        if (grid != null) {
            if (grid.getViewType() == 1) {
                gridFilters.add(new CraftableGridFilter(false));
            } else if (grid.getViewType() == 2) {
                gridFilters.add(new CraftableGridFilter(true));
            }
        }
        if (!filters.isEmpty()) {
            gridFilters.add(new FilterGridFilter(filters));
        }
        return AndGridFilter.of(gridFilters);
    }

    private static List<Predicate<IGridStack>> getFilters(String query) {
        LinkedList<Predicate<IGridStack>> gridFilters = new LinkedList<Predicate<IGridStack>>();
        for (String part : query.toLowerCase().trim().split(" ")) {
            if (part.startsWith("@")) {
                gridFilters.add(new ModGridFilter(part.substring(1)));
                continue;
            }
            if (part.startsWith("#")) {
                gridFilters.add(new TooltipGridFilter(part.substring(1)));
                continue;
            }
            if (part.startsWith("$")) {
                gridFilters.add(new TagGridFilter(part.substring(1)));
                continue;
            }
            gridFilters.add(new NameGridFilter(part));
        }
        return gridFilters;
    }
}

