/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.externalstorage.FluidExternalStorage;
import com.refinedmods.refinedstorage.blockentity.FluidInterfaceBlockEntity;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.fluid.ProxyFluidHandler;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class FluidInterfaceNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "fluid_interface");
    public static final int TANK_CAPACITY = 16000;
    private static final String NBT_TANK_IN = "TankIn";
    private static final String NBT_TANK_OUT = "TankOut";
    private static final String NBT_OUT = "Out";
    private final FluidTank tankIn = new FluidTank(16000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (!FluidInterfaceNetworkNode.this.level.f_46443_ && FluidInterfaceNetworkNode.this.level.m_46749_(FluidInterfaceNetworkNode.this.pos)) {
                ((FluidInterfaceBlockEntity)FluidInterfaceNetworkNode.this.level.m_7702_(FluidInterfaceNetworkNode.this.pos)).getDataManager().sendParameterToWatchers(FluidInterfaceBlockEntity.TANK_IN);
            }
            FluidInterfaceNetworkNode.this.markDirty();
        }
    };
    private final FluidTank tankOut = new FluidTank(16000);
    private final ProxyFluidHandler tank = new ProxyFluidHandler(this.tankIn, this.tankOut);
    private final BaseItemHandler in = new BaseItemHandler(1).addListener(new NetworkNodeInventoryListener(this)).addValidator(stack -> !((FluidStack)StackUtils.getFluid(stack, true).getValue()).isEmpty());
    private final FluidInventory out = new FluidInventory(1, 16000).addListener(new NetworkNodeFluidInventoryListener(this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK, UpgradeItem.Type.CRAFTING).addListener(new NetworkNodeInventoryListener(this));

    public FluidInterfaceNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate()) {
            FluidStack drained;
            Pair<ItemStack, FluidStack> result;
            ItemStack container = this.in.getStackInSlot(0);
            if (!container.m_41619_() && !((FluidStack)(result = StackUtils.getFluid(container, true)).getValue()).isEmpty() && this.tankIn.fill((FluidStack)result.getValue(), IFluidHandler.FluidAction.SIMULATE) == ((FluidStack)result.getValue()).getAmount()) {
                result = StackUtils.getFluid(container, false);
                this.tankIn.fill((FluidStack)result.getValue(), IFluidHandler.FluidAction.EXECUTE);
                this.in.setStackInSlot(0, (ItemStack)result.getLeft());
            }
            if (this.ticks % this.upgrades.getSpeed() == 0 && !(drained = this.tankIn.drain(1000 * this.upgrades.getStackInteractCount(), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                FluidStack remainder = this.network.insertFluidTracked(drained, drained.getAmount());
                this.tankIn.fill(remainder, IFluidHandler.FluidAction.EXECUTE);
            }
            FluidStack wanted = this.out.getFluid(0);
            FluidStack got = this.tankOut.getFluid();
            if (wanted.isEmpty()) {
                if (!got.isEmpty()) {
                    this.tankOut.setFluid(this.network.insertFluidTracked(got, got.getAmount()));
                    this.onTankOutChanged();
                }
            } else if (!got.isEmpty() && !API.instance().getComparer().isEqual(wanted, got, 1)) {
                this.tankOut.setFluid(this.network.insertFluidTracked(got, got.getAmount()));
                this.onTankOutChanged();
            } else {
                int delta;
                int n = delta = got.isEmpty() ? wanted.getAmount() : wanted.getAmount() - got.getAmount();
                if (delta > 0) {
                    boolean actingAsStorage = this.isActingAsStorage();
                    FluidStack result2 = this.network.extractFluid(wanted, delta, 1, Action.PERFORM, s -> {
                        if (!actingAsStorage) {
                            return true;
                        }
                        return !(s instanceof FluidExternalStorage) || !((FluidExternalStorage)s).isConnectedToInterface();
                    });
                    if (!result2.isEmpty()) {
                        if (this.tankOut.getFluid().isEmpty()) {
                            this.tankOut.setFluid(result2);
                        } else {
                            this.tankOut.getFluid().grow(result2.getAmount());
                        }
                        this.onTankOutChanged();
                    }
                    if ((delta -= result2.getAmount()) > 0 && this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                        this.network.getCraftingManager().request((Object)this, wanted, delta);
                    }
                } else if (delta < 0) {
                    FluidStack remainder = this.network.insertFluidTracked(got, Math.abs(delta));
                    this.tankOut.getFluid().shrink(Math.abs(delta) - remainder.getAmount());
                    this.onTankOutChanged();
                }
            }
        }
    }

    private boolean isActingAsStorage() {
        for (Direction facing : Direction.values()) {
            INetworkNode facingNode = API.instance().getNetworkNodeManager((ServerLevel)this.level).getNode(this.pos.m_121945_(facing));
            if (!(facingNode instanceof ExternalStorageNetworkNode) || !facingNode.isActive() || ((ExternalStorageNetworkNode)facingNode).getDirection() != facing.m_122424_() || ((ExternalStorageNetworkNode)facingNode).getType() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getFluidInterface().getUsage();
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 0, tag);
        StackUtils.writeItems((IItemHandler)this.in, 1, tag);
        tag.m_128365_(NBT_TANK_IN, (Tag)this.tankIn.writeToNBT(new CompoundTag()));
        tag.m_128365_(NBT_TANK_OUT, (Tag)this.tankOut.writeToNBT(new CompoundTag()));
        return tag;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems(this.upgrades, 0, tag);
        StackUtils.readItems(this.in, 1, tag);
        if (tag.m_128441_(NBT_TANK_IN)) {
            this.tankIn.readFromNBT(tag.m_128469_(NBT_TANK_IN));
        }
        if (tag.m_128441_(NBT_TANK_OUT)) {
            this.tankOut.readFromNBT(tag.m_128469_(NBT_TANK_OUT));
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128365_(NBT_OUT, (Tag)this.out.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_OUT)) {
            this.out.readFromNbt(tag.m_128469_(NBT_OUT));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public BaseItemHandler getIn() {
        return this.in;
    }

    public FluidInventory getOut() {
        return this.out;
    }

    public ProxyFluidHandler getTank() {
        return this.tank;
    }

    public FluidTank getTankIn() {
        return this.tankIn;
    }

    public FluidTank getTankOut() {
        return this.tankOut;
    }

    private void onTankOutChanged() {
        if (!this.level.f_46443_ && this.level.m_46749_(this.pos)) {
            ((FluidInterfaceBlockEntity)this.level.m_7702_(this.pos)).getDataManager().sendParameterToWatchers(FluidInterfaceBlockEntity.TANK_OUT);
        }
        this.markDirty();
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.in, this.upgrades});
    }
}

