/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public class QuarryChunkLoadUtil {
    private static final Logger LOGGER = QuarryPlus.getLogger(QuarryChunkLoadUtil.class);
    static final TicketType<ChunkPos> QUARRY_PLUS_MINING = TicketType.m_9462_((String)"%s:%s".formatted("quarryplus", "mining_ticket"), Comparator.comparingLong(ChunkPos::m_45588_));
    static final int TICKET_LEVEL = 33;

    private static boolean isChunkLoadDisabled() {
        return QuarryPlus.config == null || (Boolean)QuarryPlus.config.common.enableChunkLoader.get() == false;
    }

    public static boolean isChunkLoaded(Level world, BlockPos pos) {
        if (QuarryChunkLoadUtil.isChunkLoadDisabled()) {
            return false;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            long key = new ChunkPos(pos).m_45588_();
            return serverWorld.m_8902_().contains(key);
        }
        return false;
    }

    public static boolean makeChunkLoaded(Level world, BlockPos pos, boolean machineEnabled) {
        if (QuarryChunkLoadUtil.isChunkLoadDisabled()) {
            return false;
        }
        if (!machineEnabled) {
            return false;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            boolean chunkLoaded = QuarryChunkLoadUtil.isChunkLoaded(world, pos);
            LOGGER.debug("Asked to force loading chunk at {}, loaded={}", (Object)pos, (Object)chunkLoaded);
            if (chunkLoaded) {
                return true;
            }
            serverWorld.m_8602_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), true);
            return false;
        }
        return false;
    }

    public static void makeChunkUnloaded(Level world, BlockPos pos, boolean preLoaded) {
        if (QuarryChunkLoadUtil.isChunkLoadDisabled()) {
            return;
        }
        LOGGER.debug("Asked to unload chunk at {}. preLoaded={}", (Object)pos, (Object)preLoaded);
        if (!preLoaded && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8602_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), false);
        }
    }

    public static void makeChunkLoadedForMining(ServerLevel level, Area area) {
        if (QuarryChunkLoadUtil.isChunkLoadDisabled()) {
            return;
        }
        LOGGER.debug("Make custom chunk load ticket for {}", (Object)area);
        DistanceManager distanceManager = level.m_7726_().f_8325_.m_143145_();
        QuarryChunkLoadUtil.operateForChunks(area, pos -> distanceManager.m_140792_(QUARRY_PLUS_MINING, pos, 33, pos));
    }

    public static void removeChunkLoadTicket(ServerLevel level, Area area) {
        if (QuarryChunkLoadUtil.isChunkLoadDisabled()) {
            return;
        }
        LOGGER.debug("Remove custom chunk load ticket for {}", (Object)area);
        DistanceManager distanceManager = level.m_7726_().f_8325_.m_143145_();
        QuarryChunkLoadUtil.operateForChunks(area, pos -> distanceManager.m_140823_(QUARRY_PLUS_MINING, pos, 33, pos));
    }

    static void operateForChunks(Area area, Consumer<ChunkPos> consumer) {
        int minX = SectionPos.m_123171_((int)area.minX());
        int minZ = SectionPos.m_123171_((int)area.minZ());
        int maxX = SectionPos.m_123171_((int)area.maxX());
        int maxZ = SectionPos.m_123171_((int)area.maxZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                consumer.accept(new ChunkPos(x, z));
            }
        }
    }
}

