/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solar;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.solar.SolarTile;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.inventory.SolarContainer;
import owmii.powah.lib.block.AbstractGeneratorBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class SolarBlock
extends AbstractGeneratorBlock<SolarBlock>
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = SolarBlock.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;

    public SolarBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        return super.getBlockItem(properties.m_41487_(1), (ResourceKey)group);
    }

    @Override
    public GeneratorConfig getConfig() {
        return Powah.config().generators.solar_panels;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SolarTile(pos, state, (Tier)this.variant);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof SolarTile) {
            return new SolarContainer(id, inventory, (SolarTile)te);
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return this.createState(world, currentPos);
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.createState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    private BlockState createState(LevelAccessor world, BlockPos pos) {
        BlockState state = this.m_49966_();
        boolean north = this.canAttach(state, world, pos, Direction.NORTH);
        boolean south = this.canAttach(state, world, pos, Direction.SOUTH);
        boolean west = this.canAttach(state, world, pos, Direction.WEST);
        boolean east = this.canAttach(state, world, pos, Direction.EAST);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(!north))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(!south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(!west))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(!east))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public boolean canAttach(BlockState state, LevelAccessor world, BlockPos pos, Direction direction) {
        return world.m_8055_(pos.m_121945_(direction)).m_60734_() == this;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST});
        super.m_7926_(builder);
    }

    public List<Direction> getConnectedSides(BlockState state) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (!((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            list.add(Direction.NORTH);
        }
        if (!((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            list.add(Direction.SOUTH);
        }
        if (!((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            list.add(Direction.WEST);
        }
        if (!((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            list.add(Direction.EAST);
        }
        return list;
    }
}

