/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.Tier;
import owmii.powah.block.ender.EnderNetwork;
import owmii.powah.config.v2.types.EnderConfig;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.IOwnable;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.math.RangedInt;

public class AbstractEnderTile<B extends AbstractEnergyBlock<EnderConfig, B>>
extends AbstractEnergyStorage<EnderConfig, B>
implements IOwnable,
IInventoryHolder {
    private final RangedInt channel = new RangedInt(12);
    @Nullable
    private GameProfile owner;
    private boolean flag;

    public AbstractEnderTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Tier variant) {
        super(type, pos, state, variant);
    }

    @Override
    public void readStorable(CompoundTag nbt) {
        super.readStorable(nbt);
        this.channel.read(nbt, "channel");
        if (nbt.m_128403_("owner_id")) {
            this.owner = new GameProfile(nbt.m_128342_("owner_id"), nbt.m_128461_("owner_name"));
        }
    }

    @Override
    public CompoundTag writeStorable(CompoundTag nbt) {
        this.channel.write(nbt, "channel");
        if (this.owner != null) {
            nbt.m_128362_("owner_id", this.owner.getId());
            nbt.m_128359_("owner_name", this.owner.getName());
        }
        return super.writeStorable(nbt);
    }

    @Override
    protected void onFirstTick(Level world) {
        super.onFirstTick(world);
        this.getEnergy().setTransfer(this.getEnergyTransfer());
    }

    @Override
    protected int postTick(Level world) {
        if (!this.isRemote() && this.energy.clone(this.getEnergy())) {
            this.sync(5);
        }
        return this.chargeItems(1, 3) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    @Override
    public void onSlotChanged(int slot) {
        if (this.f_58857_ != null && slot == 0) {
            ItemStack stack = this.inv.getStackInSlot(0);
            if (this.isExtender() && stack.m_41720_() instanceof IEnderExtender) {
                Energy energy = this.getEnergy();
                IEnderExtender e = (IEnderExtender)stack.m_41720_();
                long cap = e.getExtendedCapacity(stack);
                long newCap = energy.getCapacity() + cap;
                if (cap <= 9000000000000000000L && newCap > 0L && newCap <= 9000000000000000000L) {
                    if (!this.isRemote()) {
                        energy.setCapacity(newCap);
                        energy.setStored(e.getExtendedEnergy(stack) + this.getEnergy().getStored());
                        this.setEnergy(energy);
                    }
                    stack.m_41774_(1);
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11897_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable Direction side) {
        long l = super.receiveEnergy(maxReceive, simulate, side);
        this.setEnergy(this.getEnergy());
        return l;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate, @Nullable Direction side) {
        long l = super.extractEnergy(maxExtract, simulate, side);
        this.setEnergy(this.getEnergy());
        return l;
    }

    @Override
    public boolean canExtractEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canExtractEnergy(side);
    }

    @Override
    public boolean canReceiveEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canReceiveEnergy(side);
    }

    @Override
    public void onPlaced(Level world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlaced(world, state, placer, stack);
        if (this.getOwner() == null && placer instanceof ServerPlayer && !owmii.powah.lib.util.Player.isFake((Player)placer)) {
            this.setOwner(((ServerPlayer)placer).m_36316_());
        }
    }

    public void setEnergy(Energy energy) {
        if (!this.isRemote() && this.owner != null) {
            EnderNetwork network = EnderNetwork.get(this.f_58857_);
            network.setEnergy(this.owner.getId(), this.channel.get(), energy);
        }
    }

    public boolean isExtender() {
        return true;
    }

    @Override
    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public Energy getEnergy() {
        if (this.isRemote()) {
            return this.energy;
        }
        return EnderNetwork.get(this.f_58857_).getEnergy(this, this.channel.get()).setTransfer(this.getEnergyTransfer());
    }

    public RangedInt getChannel() {
        return this.channel;
    }

    public int getMaxChannels() {
        return ((EnderConfig)this.getConfig()).channels.get((Tier)this.getVariant());
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        if (slot == 0) {
            Item item = stack.m_41720_();
            if (item instanceof IEnderExtender) {
                IEnderExtender extender = (IEnderExtender)item;
                long l = extender.getExtendedCapacity(stack);
                return l > 0L && l + this.getEnergy().getCapacity() <= 9000000000000000000L;
            }
            return false;
        }
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

