/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipe;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CTShapedRecipeSerializer
implements RecipeSerializer<CTShapedRecipe> {
    public static final CTShapedRecipeSerializer INSTANCE = new CTShapedRecipeSerializer();

    private CTShapedRecipeSerializer() {
    }

    public CTShapedRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
        return this.makeRecipe(CraftTweakerConstants.rl("invalid_recipe"), IItemStack.of(new ItemStack((ItemLike)Items.f_42127_)), new IIngredient[][]{{IItemStack.of(new ItemStack((ItemLike)Items.f_42127_))}}, MirrorAxis.NONE, null);
    }

    public CTShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int height = buffer.m_130242_();
        int width = buffer.m_130242_();
        IIngredient[][] inputs = new IIngredient[height][width];
        for (int h = 0; h < inputs.length; ++h) {
            for (int w = 0; w < inputs[h].length; ++w) {
                inputs[h][w] = IIngredient.fromIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
        }
        MirrorAxis mirrorAxis = (MirrorAxis)buffer.m_130066_(MirrorAxis.class);
        ItemStack output = buffer.m_130267_();
        return this.makeRecipe(recipeId, IItemStack.of(output), inputs, mirrorAxis, null);
    }

    public void toNetwork(FriendlyByteBuf buffer, CTShapedRecipe recipe) {
        buffer.m_130130_(recipe.m_44221_());
        buffer.m_130130_(recipe.m_44220_());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130068_((Enum)recipe.getMirrorAxis());
        buffer.m_130055_(AccessibleElementsProvider.get().registryAccess(recipe::m_8043_));
    }

    public CTShapedRecipe makeRecipe(ResourceLocation recipeId, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        return new CTShapedRecipe(recipeId.m_135815_(), output, ingredients, mirrorAxis, function);
    }
}

