/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.data.recipes;

import com.stal111.valhelsia_structures.common.block.PostBlock;
import com.stal111.valhelsia_structures.common.recipe.AxeCraftingRecipeBuilder;
import com.stal111.valhelsia_structures.core.init.ModBlocks;
import com.stal111.valhelsia_structures.utils.ModTags;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;
import net.valhelsia.valhelsia_core.api.datagen.recipes.RecipePart;
import net.valhelsia.valhelsia_core.api.datagen.recipes.RecipeSubProvider;
import net.valhelsia.valhelsia_core.api.datagen.recipes.ValhelsiaRecipeProvider;

public class ModRecipeProvider
extends RecipeSubProvider {
    public static final EnumMap<ModBlocks.WoodType, Block> WOOD_TYPE_TO_LOG = (EnumMap)Util.m_137469_(new EnumMap(ModBlocks.WoodType.class), map -> {
        map.put(ModBlocks.WoodType.OAK, Blocks.f_49999_);
        map.put(ModBlocks.WoodType.SPRUCE, Blocks.f_50000_);
        map.put(ModBlocks.WoodType.BIRCH, Blocks.f_50001_);
        map.put(ModBlocks.WoodType.JUNGLE, Blocks.f_50002_);
        map.put(ModBlocks.WoodType.ACACIA, Blocks.f_50003_);
        map.put(ModBlocks.WoodType.DARK_OAK, Blocks.f_50004_);
        map.put(ModBlocks.WoodType.MANGROVE, Blocks.f_220832_);
        map.put(ModBlocks.WoodType.CRIMSON, Blocks.f_50695_);
        map.put(ModBlocks.WoodType.WARPED, Blocks.f_50686_);
        map.put(ModBlocks.WoodType.LAPIDIFIED_JUNGLE, (Block)ModBlocks.LAPIDIFIED_JUNGLE_LOG.get());
    });
    public static final EnumMap<ModBlocks.WoodType, Block> WOOD_TYPE_TO_STRIPPED_LOG = (EnumMap)Util.m_137469_(new EnumMap(ModBlocks.WoodType.class), map -> {
        map.put(ModBlocks.WoodType.OAK, Blocks.f_50010_);
        map.put(ModBlocks.WoodType.SPRUCE, Blocks.f_50005_);
        map.put(ModBlocks.WoodType.BIRCH, Blocks.f_50006_);
        map.put(ModBlocks.WoodType.JUNGLE, Blocks.f_50007_);
        map.put(ModBlocks.WoodType.ACACIA, Blocks.f_50008_);
        map.put(ModBlocks.WoodType.DARK_OAK, Blocks.f_50009_);
        map.put(ModBlocks.WoodType.MANGROVE, Blocks.f_220832_);
        map.put(ModBlocks.WoodType.CRIMSON, Blocks.f_50696_);
        map.put(ModBlocks.WoodType.WARPED, Blocks.f_50687_);
        map.put(ModBlocks.WoodType.LAPIDIFIED_JUNGLE, (Block)ModBlocks.LAPIDIFIED_JUNGLE_LOG.get());
    });

    public ModRecipeProvider(ValhelsiaRecipeProvider provider) {
        super(provider);
    }

    protected void registerRecipes() {
        this.brazier((ItemLike)ModBlocks.BRAZIER.get(), (TagKey<Item>)ItemTags.f_13160_);
        this.brazier((ItemLike)ModBlocks.SOUL_BRAZIER.get(), (TagKey<Item>)ItemTags.f_13154_);
        for (ModBlocks.WoodType woodType2 : ModBlocks.WoodType.values()) {
            PostBlock postBlock = (PostBlock)((Object)((BlockRegistryEntry)ModBlocks.WOODEN_POSTS.get((Object)woodType2)).get());
            PostBlock strippedPostBlock = (PostBlock)((Object)((BlockRegistryEntry)ModBlocks.STRIPPED_WOODEN_POSTS.get((Object)woodType2)).get());
            Block logBlock = WOOD_TYPE_TO_LOG.get((Object)woodType2);
            Block strippedLogBlock = WOOD_TYPE_TO_STRIPPED_LOG.get((Object)woodType2);
            this.add(new AxeCraftingRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, Ingredient.m_43929_((ItemLike[])new ItemLike[]{logBlock}), (ItemLike)postBlock, 2).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{logBlock})));
            this.add(new AxeCraftingRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, Ingredient.m_43929_((ItemLike[])new ItemLike[]{strippedLogBlock}), (ItemLike)strippedPostBlock, 2).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{strippedLogBlock})));
            this.add(new AxeCraftingRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, Ingredient.m_43929_((ItemLike[])new ItemLike[]{postBlock}), (ItemLike)((BlockRegistryEntry)ModBlocks.CUT_WOODEN_POSTS.get((Object)woodType2)).get(), 4).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{postBlock})));
            this.add(new AxeCraftingRecipeBuilder(RecipeCategory.BUILDING_BLOCKS, Ingredient.m_43929_((ItemLike[])new ItemLike[]{strippedPostBlock}), (ItemLike)((BlockRegistryEntry)ModBlocks.CUT_STRIPPED_WOODEN_POSTS.get((Object)woodType2)).get(), 4).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{strippedPostBlock})));
        }
        this.metalFramedGlass((ItemLike)ModBlocks.METAL_FRAMED_GLASS.get(), RecipePart.of((Object)Tags.Items.GLASS_COLORLESS));
        this.glassPane((ItemLike)ModBlocks.METAL_FRAMED_GLASS_PANE.get(), RecipePart.of((Object)((GlassBlock)ModBlocks.METAL_FRAMED_GLASS.get())));
        ModBlocks.COLORED_METAL_FRAMED_GLASS.forEach((color, registryObject) -> {
            Block block = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.m_41065_() + "_stained_glass")));
            this.metalFramedGlass((ItemLike)registryObject.get(), RecipePart.of((Object)block));
        });
        ModBlocks.COLORED_METAL_FRAMED_GLASS_PANES.forEach((color, registryObject) -> {
            Block block = (Block)((BlockRegistryEntry)ModBlocks.COLORED_METAL_FRAMED_GLASS.get(color)).get();
            this.glassPane((ItemLike)registryObject.get(), RecipePart.of((Object)block));
        });
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.PAPER_WALL.get(), 2, builder -> builder.pattern("#X#").pattern("#X#").pattern("#X#").define(Character.valueOf('#'), (ItemLike)Items.f_41911_).define(Character.valueOf('X'), (ItemLike)Items.f_42516_).unlockedBy((RecipeSubProvider)this, (ItemLike)Items.f_41911_));
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.BONE_PILE.get(), 3, builder -> builder.pattern("###").define(Character.valueOf('#'), (ItemLike)Items.f_42500_).group("bone_pile").unlockedBy((RecipeSubProvider)this, (ItemLike)Items.f_42500_));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.BONE_PILE.get(), 9, builder -> builder.m_126209_((ItemLike)ModBlocks.BONE_PILE_BLOCK.get()).m_126145_("bone_pile").m_126132_(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.BONE_PILE_BLOCK.get())), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BONE_PILE_BLOCK.get()})), "bone_pile_from_bone_pile_block");
        this.storageRecipe((ItemLike)Items.f_42500_, (ItemLike)ModBlocks.BONE_PILE_BLOCK.get());
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.BONE_PILE_BLOCK.get(), builder -> builder.pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModBlocks.BONE_PILE.get()).group("bone_pile_block").unlockedBy((RecipeSubProvider)this, (ItemLike)ModBlocks.BONE_PILE.get()), "bone_pile_block_from_bone_piles");
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.EXPLORERS_TENT.get(), builder -> builder.pattern(" # ").pattern("#X#").pattern("#X#").define(Character.valueOf('#'), Tags.Items.LEATHER).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((RecipeSubProvider)this, RecipePart.of((Object)Tags.Items.LEATHER)));
        this.glazedJar((ItemLike)ModBlocks.GLAZED_JAR.get(), (ItemLike)Blocks.f_50352_);
        this.bigGlazedJar((ItemLike)ModBlocks.BIG_GLAZED_JAR.get(), (ItemLike)Blocks.f_50352_);
        ModBlocks.COLORED_GLAZED_JARS.values().forEach(registryObject -> {
            String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get()))).m_135815_();
            Block block = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name.substring(0, name.length() - 11) + "_terracotta")));
            this.glazedJar((ItemLike)registryObject.get(), (ItemLike)block);
        });
        ModBlocks.BIG_COLORED_GLAZED_JARS.values().forEach(registryObject -> {
            String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get()))).m_135815_();
            Block block = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name.substring(4, name.length() - 11) + "_terracotta")));
            this.bigGlazedJar((ItemLike)registryObject.get(), (ItemLike)block);
        });
        this.surroundingItem(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_LOG.get(), RecipePart.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50191_, (ItemLike)ModBlocks.HANGING_VINES.get()})), RecipePart.of((Object)Blocks.f_50002_), 8);
        this.wood((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_WOOD.get(), RecipePart.of((Object)((RotatedPillarBlock)ModBlocks.LAPIDIFIED_JUNGLE_LOG.get())));
        this.planks((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_PLANKS.get(), ModTags.Items.LAPIDIFIED_JUNGLE_LOGS);
        this.slab((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_SLAB.get(), RecipePart.of((Object)((Block)ModBlocks.LAPIDIFIED_JUNGLE_PLANKS.get())));
        this.stairs((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_STAIRS.get(), RecipePart.of((Object)((Block)ModBlocks.LAPIDIFIED_JUNGLE_PLANKS.get())));
        this.pressurePlate((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_PRESSURE_PLATE.get(), RecipePart.of((Object)((Block)ModBlocks.LAPIDIFIED_JUNGLE_PLANKS.get())));
        this.button((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_BUTTON.get(), (ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_PLANKS.get());
        this.fence((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_FENCE.get(), RecipePart.of((Object)((Block)ModBlocks.LAPIDIFIED_JUNGLE_PLANKS.get())));
        this.fenceGate((ItemLike)ModBlocks.LAPIDIFIED_JUNGLE_FENCE_GATE.get(), RecipePart.of((Object)((Block)ModBlocks.LAPIDIFIED_JUNGLE_PLANKS.get())));
        ModBlocks.BUNDLED_POSTS.forEach((woodType, registryObject) -> this.simple2x2(RecipeCategory.BUILDING_BLOCKS, (ItemLike)registryObject.get(), RecipePart.of((Object)((Object)((PostBlock)((Object)((Object)((BlockRegistryEntry)ModBlocks.WOODEN_POSTS.get((Object)woodType)).get())))))));
        ModBlocks.BUNDLED_STRIPPED_POSTS.forEach((woodType, registryObject) -> this.simple2x2(RecipeCategory.BUILDING_BLOCKS, (ItemLike)registryObject.get(), RecipePart.of((Object)((Object)((PostBlock)((Object)((Object)((BlockRegistryEntry)ModBlocks.STRIPPED_WOODEN_POSTS.get((Object)woodType)).get())))))));
        Block whiteSleepingBag = (Block)((BlockRegistryEntry)ModBlocks.SLEEPING_BAGS.get((Object)DyeColor.WHITE)).get();
        ModBlocks.SLEEPING_BAGS.forEach((color, entry) -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.m_41065_() + "_wool"));
            if (block != null) {
                this.singleRow(RecipeCategory.DECORATIONS, (ItemLike)entry.get(), RecipePart.of((Object)block));
            }
            if (color != DyeColor.WHITE) {
                this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)entry.get(), builder -> builder.m_126209_((ItemLike)whiteSleepingBag).m_206419_(color.getTag()).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{whiteSleepingBag})).m_126132_("has_color", (CriterionTriggerInstance)ModRecipeProvider.has((TagKey)color.getTag())), BuiltInRegistries.f_256975_.m_7981_((Object)((Block)entry.get())).m_135815_() + "_from_white_sleeping_bag");
            }
        });
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.GLAZED_JAR.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CRACKED_GLAZED_JAR.get()), (float)0.1f, (int)200).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.GLAZED_JAR.get()})), "smelting/cracked_glazed_jar");
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BIG_GLAZED_JAR.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.CRACKED_BIG_GLAZED_JAR.get()), (float)0.1f, (int)200).m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BIG_GLAZED_JAR.get()})), "smelting/cracked_big_glazed_jar");
    }

    public void brazier(ItemLike result, TagKey<Item> tagKey) {
        this.shaped(RecipeCategory.DECORATIONS, result, builder -> builder.pattern("*X*").pattern("###").define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('X'), tagKey).define(Character.valueOf('*'), (ItemLike)Items.f_42025_).unlockedBy("has_" + tagKey.f_203868_().m_135815_(), (CriterionTriggerInstance)ModRecipeProvider.has((TagKey)tagKey)).unlockedBy("has_iron_bars", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike[])new ItemLike[]{Items.f_42025_})));
    }

    public void metalFramedGlass(ItemLike result, RecipePart<?> glass) {
        this.surroundingItem(RecipeCategory.BUILDING_BLOCKS, result, RecipePart.of((Object)Tags.Items.INGOTS_IRON), glass, 8);
    }

    public void glazedJar(ItemLike result, ItemLike terracotta) {
        this.shaped(RecipeCategory.DECORATIONS, result, builder -> builder.pattern("# #").pattern(" # ").define(Character.valueOf('#'), terracotta).group("glazedJar").unlockedBy((RecipeSubProvider)this, terracotta));
    }

    public void bigGlazedJar(ItemLike result, ItemLike terracotta) {
        this.shaped(RecipeCategory.DECORATIONS, result, builder -> builder.pattern("# #").pattern("# #").pattern(" # ").define(Character.valueOf('#'), terracotta).group("biGlazedJar").unlockedBy((RecipeSubProvider)this, terracotta));
    }
}

