/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.core.init.world;

import com.stal111.valhelsia_structures.common.world.structures.ValhelsiaJigsawStructure;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.pools.BigTreePools;
import com.stal111.valhelsia_structures.common.world.structures.pools.DesertHousePools;
import com.stal111.valhelsia_structures.common.world.structures.pools.PlayerHousePools;
import com.stal111.valhelsia_structures.common.world.structures.pools.SimpleStructurePools;
import com.stal111.valhelsia_structures.common.world.structures.pools.SpawnerDungeonPools;
import com.stal111.valhelsia_structures.core.ValhelsiaStructures;
import com.stal111.valhelsia_structures.utils.ModTags;
import com.stal111.valhelsia_structures.utils.StartPoolKeySet;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryClass;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryHelper;

public class ModStructures
extends DatapackRegistryClass<Structure> {
    public static final DatapackRegistryHelper<Structure> HELPER = (DatapackRegistryHelper)ValhelsiaStructures.REGISTRY_MANAGER.getHelper(Registries.f_256944_);
    public static final ResourceKey<Structure> CASTLE = HELPER.createKey("castle");
    public static final ResourceKey<Structure> CASTLE_RUIN = HELPER.createKey("castle_ruin");
    public static final ResourceKey<Structure> DESERT_HOUSE = HELPER.createKey("desert_house");
    public static final ResourceKey<Structure> FORGE = HELPER.createKey("forge");
    public static final ResourceKey<Structure> PLAYER_HOUSE = HELPER.createKey("player_house");
    public static final ResourceKey<Structure> SPAWNER_DUNGEON = HELPER.createKey("spawner_dungeon");
    public static final ResourceKey<Structure> TOWER_RUIN = HELPER.createKey("tower_ruin");
    public static final ResourceKey<Structure> WITCH_HUT = HELPER.createKey("witch_hut");
    public static final ResourceKey<Structure> BIG_TREE = HELPER.createKey("big_tree");
    public static final ResourceKey<Structure> SPAWNER_ROOM = HELPER.createKey("spawner_room");
    public static final ResourceKey<Structure> DEEP_SPAWNER_ROOM = HELPER.createKey("deep_spawner_room");

    public ModStructures(BootstapContext<Structure> context) {
        super(context);
    }

    public void bootstrap(BootstapContext<Structure> context) {
        HolderGetter biomeHolderGetter = context.m_255420_(Registries.f_256952_);
        HolderSet.Named<Biome> castleBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_CASTLE);
        HolderSet.Named<Biome> castleRuinBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_CASTLE_RUIN);
        AndHolderSet<Biome> desertHouseBiomes = this.withConditionTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_DESERT_HOUSE, ModTags.Biomes.DESERT_HOUSE_CONDITION);
        HolderSet.Named<Biome> forgeBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_FORGE);
        HolderSet.Named<Biome> playerHouseBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_PLAYER_HOUSE);
        HolderSet.Named<Biome> spawnerDungeonBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_SPAWNER_DUNGEON);
        HolderSet.Named<Biome> towerRuinBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_TOWER_RUIN);
        HolderSet.Named<Biome> witchHutBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_WITCH_HUT);
        HolderSet.Named<Biome> bigTreeBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_BIG_TREE);
        HolderSet.Named<Biome> spawnerRoomBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_SPAWNER_ROOM);
        HolderSet.Named<Biome> deepSpawnerRoomBiomes = this.singleTag((HolderGetter<Biome>)biomeHolderGetter, ModTags.Biomes.HAS_DEEP_SPAWNER_ROOM);
        this.surfaceStructure(context, CASTLE, (HolderSet<Biome>)castleBiomes, TerrainAdjustment.BEARD_THIN, SimpleStructurePools.CASTLES, builder -> builder.chance(0.4));
        this.surfaceStructure(context, CASTLE_RUIN, (HolderSet<Biome>)castleRuinBiomes, TerrainAdjustment.BEARD_THIN, SimpleStructurePools.CASTLE_RUINS, builder -> builder.chance(0.5));
        this.surfaceStructure(context, DESERT_HOUSE, (HolderSet<Biome>)desertHouseBiomes, TerrainAdjustment.BEARD_THIN, DesertHousePools.START, builder -> builder.chance(0.7));
        this.surfaceStructure(context, FORGE, (HolderSet<Biome>)forgeBiomes, TerrainAdjustment.BEARD_THIN, SimpleStructurePools.FORGES, builder -> builder.chance(0.65));
        this.surfaceStructure(context, PLAYER_HOUSE, (HolderSet<Biome>)playerHouseBiomes, TerrainAdjustment.BEARD_THIN, PlayerHousePools.START, builder -> builder.chance(0.65));
        this.surfaceStructure(context, SPAWNER_DUNGEON, (HolderSet<Biome>)spawnerDungeonBiomes, TerrainAdjustment.NONE, SpawnerDungeonPools.START, builder -> builder.chance(0.7).startHeight(StructureHeightProvider.surfaceBetween(VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158922_((int)75))).individualTerrainAdjustment());
        this.surfaceStructure(context, TOWER_RUIN, (HolderSet<Biome>)towerRuinBiomes, TerrainAdjustment.BEARD_THIN, SimpleStructurePools.TOWER_RUINS, builder -> builder.chance(0.7));
        this.surfaceStructure(context, WITCH_HUT, (HolderSet<Biome>)witchHutBiomes, TerrainAdjustment.BEARD_THIN, SimpleStructurePools.WITCH_HUTS, builder -> builder.chance(0.85).margin(3).addSpawnOverride(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 1, 1, 1)}))).addSpawnOverride(MobCategory.CREATURE, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20553_, 1, 1, 1)}))));
        this.surfaceStructure(context, BIG_TREE, (HolderSet<Biome>)bigTreeBiomes, TerrainAdjustment.BEARD_THIN, BigTreePools.START, builder -> builder.chance(0.6));
        this.undergroundStructure(context, SPAWNER_ROOM, (HolderSet<Biome>)spawnerRoomBiomes, TerrainAdjustment.NONE, SimpleStructurePools.SPAWNER_ROOMS, builder -> builder.chance(0.9).startHeight(StructureHeightProvider.spawnerRoom(VerticalAnchor.m_158922_((int)0))));
        this.undergroundStructure(context, DEEP_SPAWNER_ROOM, (HolderSet<Biome>)deepSpawnerRoomBiomes, TerrainAdjustment.NONE, SimpleStructurePools.DEEP_SPAWNER_ROOMS, builder -> builder.startHeight(StructureHeightProvider.deepSpawnerRoom(VerticalAnchor.m_158930_((int)6), VerticalAnchor.m_158922_((int)-1))));
    }

    protected void surfaceStructure(BootstapContext<Structure> context, ResourceKey<Structure> key, HolderSet<Biome> biomeHolderSet, TerrainAdjustment terrainAdjustment, StartPoolKeySet startPool, UnaryOperator<ValhelsiaJigsawStructure.Builder> builderUnaryOperator) {
        context.m_255272_(key, (Object)((ValhelsiaJigsawStructure.Builder)builderUnaryOperator.apply(ValhelsiaJigsawStructure.builder(context, biomeHolderSet, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, terrainAdjustment, startPool))).build());
    }

    protected void undergroundStructure(BootstapContext<Structure> context, ResourceKey<Structure> key, HolderSet<Biome> biomeHolderSet, TerrainAdjustment terrainAdjustment, StartPoolKeySet startPool, UnaryOperator<ValhelsiaJigsawStructure.Builder> builderUnaryOperator) {
        context.m_255272_(key, (Object)((ValhelsiaJigsawStructure.Builder)builderUnaryOperator.apply(ValhelsiaJigsawStructure.builder(context, biomeHolderSet, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, terrainAdjustment, startPool))).build());
    }

    private HolderSet.Named<Biome> singleTag(HolderGetter<Biome> biomeHolderGetter, TagKey<Biome> tagKey) {
        return biomeHolderGetter.m_254956_(tagKey);
    }

    private AndHolderSet<Biome> withConditionTag(HolderGetter<Biome> biomeHolderGetter, TagKey<Biome> tagKey, TagKey<Biome> conditionTagKey) {
        return new AndHolderSet(List.of(biomeHolderGetter.m_254956_(tagKey), biomeHolderGetter.m_254956_(conditionTagKey)));
    }
}

