/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import com.stal111.valhelsia_structures.client.ClientSetup;
import com.stal111.valhelsia_structures.common.CommonSetup;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProviderType;
import com.stal111.valhelsia_structures.core.ModEventHandler;
import com.stal111.valhelsia_structures.core.ModRegistries;
import com.stal111.valhelsia_structures.core.config.ModConfig;
import com.stal111.valhelsia_structures.core.init.world.ModStructureHeightProviderTypes;
import java.io.File;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryCollector;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryManager;
import net.valhelsia.valhelsia_core.core.ModDefinition;
import net.valhelsia.valhelsia_core.core.ValhelsiaEventHandler;
import org.slf4j.Logger;

@Mod(value="valhelsia_structures")
public class ValhelsiaStructures {
    public static final String MOD_ID = "valhelsia_structures";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final RegistryManager REGISTRY_MANAGER = new RegistryManager((RegistryCollector)new ModRegistries("valhelsia_structures"));
    public static final Supplier<IForgeRegistry<StructureHeightProviderType<?>>> STRUCTURE_HEIGHT_PROVIDER_TYPES = ModStructureHeightProviderTypes.TYPES.makeRegistry(() -> new RegistryBuilder().setMaxID(0x7FFFFFFE).onAdd((owner, stage, id, key, obj, old) -> {}).setDefaultKey(new ResourceLocation(MOD_ID, "null")));
    private IForgeRegistry<StructureHeightProviderType<?>> structureHeightProviderTypes;

    public ValhelsiaStructures() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModDefinition.of((String)MOD_ID).withRegistryManager(REGISTRY_MANAGER).withEventHandler((ValhelsiaEventHandler)new ModEventHandler(eventBus)).clientSetup(() -> ClientSetup::new).create();
        ModStructureHeightProviderTypes.TYPES.register(eventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CommonSetup::setup);
        this.registerConfig(ModConfig.Type.COMMON, ModConfig.COMMON_SPEC);
        this.registerConfig(ModConfig.Type.CLIENT, ModConfig.CLIENT_SPEC);
    }

    public static boolean isFurnitureInstalled() {
        return ModList.get().isLoaded("valhelsia_furniture");
    }

    private void registerConfig(ModConfig.Type type, ForgeConfigSpec configSpec) {
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)configSpec);
        this.loadConfig(configSpec, FMLPaths.CONFIGDIR.get().resolve("valhelsia_structures-" + type.name().toLowerCase(Locale.ROOT) + ".toml").toString());
    }

    private void loadConfig(ForgeConfigSpec configSpec, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).preserveInsertionOrder().sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        configSpec.setConfig((CommentedConfig)file);
    }
}

