/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import com.stal111.valhelsia_structures.common.block.SleepingBagBlock;
import com.stal111.valhelsia_structures.common.block.entity.ExplorersTentBlockEntity;
import com.stal111.valhelsia_structures.common.block.properties.ModBlockStateProperties;
import com.stal111.valhelsia_structures.utils.ModTags;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;

public class ExplorersTentBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty SLEEPING_BAG = ModBlockStateProperties.SLEEPING_BAG;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final Map<Direction, VoxelShape> SLEEPING_BAG_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0));

    public ExplorersTentBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SLEEPING_BAG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ExplorersTentBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SLEEPING_BAG) != false ? SLEEPING_BAG_SHAPES.get(state.m_61143_((Property)FACING)) : Shapes.m_83040_();
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ExplorersTentBlockEntity)) {
            return InteractionResult.PASS;
        }
        ExplorersTentBlockEntity blockEntity2 = (ExplorersTentBlockEntity)blockEntity;
        if (stack.m_204117_(ModTags.Items.SLEEPING_BAGS) && blockEntity2.getSleepingBag().m_41619_()) {
            blockEntity2.setSleepingBag(stack.m_41777_().m_41620_(1));
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SLEEPING_BAG, (Comparable)Boolean.valueOf(true)));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!blockEntity2.getSleepingBag().m_41619_()) {
            if (level.m_5776_()) {
                return InteractionResult.CONSUME;
            }
            if (!BedBlock.m_49488_((Level)level)) {
                level.m_7471_(pos, false);
                pos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
                if (level.m_8055_(pos).m_60713_((Block)this)) {
                    level.m_7471_(pos, false);
                }
                level.m_254877_(null, level.m_269111_().m_269488_(pos.m_252807_()), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Level.ExplosionInteraction.BLOCK);
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
                if (!SleepingBagBlock.kickVillagerOutOfBed(level, pos)) {
                    player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.sleeping_bag.occupied"), true);
                }
                return InteractionResult.SUCCESS;
            }
            player.m_7720_(pos).ifLeft(problem -> {
                ComponentContents patt6822$temp;
                if (problem != null && (patt6822$temp = problem.m_36423_().m_214077_()) instanceof TranslatableContents) {
                    TranslatableContents contents = (TranslatableContents)patt6822$temp;
                    player.m_5661_((Component)Component.m_237115_((String)("block.valhelsia_structures.sleeping_bag." + contents.m_237508_().split("\\.")[3])), true);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            ExplorersTentBlockEntity blockEntity;
            BlockEntity blockEntity2;
            if (!level.m_5776_() && (blockEntity2 = level.m_7702_(pos)) instanceof ExplorersTentBlockEntity && (blockEntity = (ExplorersTentBlockEntity)blockEntity2).getSleepingBag() != null) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)blockEntity.getSleepingBag());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SLEEPING_BAG, OCCUPIED, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return (Boolean)state.m_61143_((Property)SLEEPING_BAG);
    }
}

