/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.attributizer.networking;

import jackiecrazy.attributizer.MainHandAttributizer;
import jackiecrazy.attributizer.OffhandAttributizer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncTagDataPacket {
    private static final FriendlyByteBuf.Writer<TagKey<Item>> item = (f, item) -> f.m_130085_(item.f_203868_());
    private static final FriendlyByteBuf.Writer<Map<Attribute, List<AttributeModifier>>> info = (f, info) -> f.m_236831_(info, (ff, a) -> ff.m_130085_(ForgeRegistries.ATTRIBUTES.getKey(a)), (ff, b) -> ff.m_236828_((Collection)b, (fbb, am) -> {
        fbb.m_130077_(am.m_22209_());
        fbb.writeDouble(am.m_22218_());
        fbb.writeByte(am.m_22217_().m_22235_());
    }));
    private static final FriendlyByteBuf.Reader<TagKey<Item>> ritem = f -> ItemTags.create((ResourceLocation)f.m_130281_());
    private static final FriendlyByteBuf.Reader<Map<Attribute, List<AttributeModifier>>> rinfo = f -> f.m_236847_(ff -> (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ff.m_130281_()), ff -> ff.m_236845_(p_179457_ -> new AttributeModifier(p_179457_.m_130259_(), "Attributizer tag modifier", p_179457_.readDouble(), AttributeModifier.Operation.m_22236_((int)p_179457_.readByte()))));
    private final Map<TagKey<Item>, Map<Attribute, List<AttributeModifier>>> map;
    private final int type;

    public SyncTagDataPacket(int type, Map<TagKey<Item>, Map<Attribute, List<AttributeModifier>>> map) {
        this.type = type;
        this.map = map;
    }

    public static class Handler
    implements BiConsumer<SyncTagDataPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(SyncTagDataPacket updateClientPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            if (contextSupplier.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                contextSupplier.get().enqueueWork(() -> {
                    switch (updateClientPacket.type) {
                        case 0: {
                            MainHandAttributizer.clientTagOverride(updateClientPacket.map);
                            break;
                        }
                        case 1: {
                            OffhandAttributizer.clientTagOverride(updateClientPacket.map);
                        }
                    }
                });
            }
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, SyncTagDataPacket> {
        @Override
        public SyncTagDataPacket apply(FriendlyByteBuf packetBuffer) {
            return new SyncTagDataPacket(packetBuffer.readInt(), packetBuffer.m_236847_(ritem, rinfo));
        }
    }

    public static class Encoder
    implements BiConsumer<SyncTagDataPacket, FriendlyByteBuf> {
        @Override
        public void accept(SyncTagDataPacket packet, FriendlyByteBuf packetBuffer) {
            packetBuffer.writeInt(packet.type);
            packetBuffer.m_236831_(packet.map, item, info);
        }
    }
}

