/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.attributizer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jackiecrazy.attributizer.Attributizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityAttributizer
extends SimpleJsonResourceReloadListener {
    public static final UUID MODIFIER = UUID.fromString("a516026a-bee2-4014-bcb6-b6a5776663da");
    public static final Map<Attribute, List<AttributeMod>> GLOBALMAP = new HashMap<Attribute, List<AttributeMod>>();
    public static final Map<EntityType<?>, Map<Attribute, List<AttributeMod>>> MAP = new HashMap();
    public static final Map<TagKey<EntityType<?>>, Map<Attribute, List<AttributeMod>>> ARCHETYPES = new HashMap();
    public static Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();

    public EntityAttributizer() {
        super(GSON, "attributizer/entity");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new EntityAttributizer());
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager rm, ProfilerFiller profiler) {
        MAP.clear();
        object.forEach((key, value) -> {
            JsonObject file = value.getAsJsonObject();
            file.entrySet().forEach(entry -> {
                Object name = (String)entry.getKey();
                boolean isTag = false;
                if (((String)name).startsWith("#")) {
                    isTag = true;
                    if (!((String)(name = ((String)name).substring(1))).contains(":")) {
                        name = "attributizer:" + (String)name;
                    }
                }
                JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement e : array) {
                    try {
                        UUID uid;
                        JsonObject obj = e.getAsJsonObject();
                        ResourceLocation attribute = new ResourceLocation(obj.get("attribute").getAsString());
                        Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attribute);
                        if (a == null) continue;
                        try {
                            String u = obj.get("uuid").getAsString();
                            uid = UUID.fromString(u);
                        }
                        catch (Exception ignored) {
                            uid = MODIFIER;
                        }
                        double min = 0.0;
                        double max = 0.0;
                        if (obj.has("min")) {
                            min = obj.get("min").getAsDouble();
                            max = obj.get("max").getAsDouble();
                        } else if (obj.has("modify")) {
                            min = max = obj.get("modify").getAsDouble();
                        }
                        String type = obj.get("operation").getAsString();
                        AttributeMod am = new AttributeMod(uid, min, max, Operation.valueOf(type));
                        if (((String)name).equals("all")) {
                            GLOBALMAP.putIfAbsent(a, new ArrayList());
                            GLOBALMAP.get(a).add(am);
                            continue;
                        }
                        if (isTag) {
                            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation((String)name));
                            ARCHETYPES.putIfAbsent(tag, new HashMap());
                            Map<Attribute, List<AttributeMod>> sub = ARCHETYPES.get(tag);
                            sub.putIfAbsent(a, new ArrayList());
                            sub.get(a).add(am);
                            ARCHETYPES.put(tag, sub);
                            continue;
                        }
                        ResourceLocation i = new ResourceLocation((String)name);
                        if (!ForgeRegistries.ENTITY_TYPES.containsKey(i)) continue;
                        EntityType mob = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(i);
                        MAP.putIfAbsent(mob, new HashMap());
                        Map<Attribute, List<AttributeMod>> sub = MAP.get(mob);
                        sub.putIfAbsent(a, new ArrayList());
                        sub.get(a).add(am);
                        MAP.put(mob, sub);
                    }
                    catch (Exception x) {
                        Attributizer.LOGGER.error("incomplete or malformed json under " + (String)name + "!");
                        x.printStackTrace();
                    }
                }
            });
        });
    }

    public static class AttributeMod {
        public UUID uid;
        public double min;
        public double scale;
        public Operation operation;

        public AttributeMod(UUID uid, double min, double max, Operation operation) {
            this.uid = uid;
            this.min = min;
            this.scale = max - min;
            this.operation = operation;
        }

        public void applyModifier(AttributeInstance i) {
            double random = this.min + Math.random() * this.scale;
            if (Objects.requireNonNull(this.operation) == Operation.SET_BASE) {
                i.m_22100_(random);
            } else if (i.m_22111_(this.uid) == null) {
                i.m_22125_(new AttributeModifier(this.uid, "attributizer change", random, AttributeModifier.Operation.m_22236_((int)this.operation.ordinal())));
            }
        }
    }

    public static enum Operation {
        ADDITION,
        MULTIPLY_BASE,
        MULTIPLY_TOTAL,
        SET_BASE;

    }
}

