/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.network;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.room.network.client.ClientRoomNetworkHandler;
import java.util.function.Supplier;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.network.NetworkEvent;

public record OpenMachinePreviewScreenPacket(GlobalPos machinePos, ChunkPos roomChunk, StructureTemplate internalBlocks) {
    public void toNetwork(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_236814_(this.machinePos);
        friendlyByteBuf.m_178341_(this.roomChunk);
        CompoundTag tag = this.internalBlocks.m_74618_(new CompoundTag());
        friendlyByteBuf.m_130079_(tag);
    }

    public static OpenMachinePreviewScreenPacket fromNetwork(FriendlyByteBuf friendlyByteBuf) {
        GlobalPos machinePos = friendlyByteBuf.m_236872_();
        ChunkPos chunkPos = friendlyByteBuf.m_178383_();
        StructureTemplate blocks = new StructureTemplate();
        blocks.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), friendlyByteBuf.m_130081_(NbtAccounter.f_128917_));
        return new OpenMachinePreviewScreenPacket(machinePos, chunkPos, blocks);
    }

    public static boolean handle(OpenMachinePreviewScreenPacket pkt, Supplier<NetworkEvent.Context> context) {
        try {
            CompactMachines.LOGGER.debug("Opening machine preview screen: {}", (Object)pkt.roomChunk);
            ClientRoomNetworkHandler.openRoomPreviewScreen(pkt);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return true;
    }
}

