/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.data;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.room.data.CompactRoomData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.CsvOutput;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public class CMRoomDataExportCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> makeRoomCsv() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"rooms").requires(cs -> cs.m_6761_(2))).executes(CMRoomDataExportCommand::execAll);
    }

    private static int execAll(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.m_81377_();
        ServerLevel compact = serv.m_129880_(CompactDimension.LEVEL_KEY);
        CompactRoomData rooms = CompactRoomData.get(compact);
        File outdir = src.m_81377_().m_129971_("compactmachines");
        Path out = outdir.toPath().resolve("rooms.csv").toAbsolutePath();
        try {
            Files.createDirectories(outdir.toPath(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(out, new OpenOption[0]);
            CsvOutput builder = CMRoomDataExportCommand.makeCsv(writer);
            rooms.streamRooms().forEach(room -> CMRoomDataExportCommand.writeRoom(room, builder));
            writer.close();
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
            src.m_81352_((Component)TranslationUtil.command(CMCommands.FAILED_CMD_FILE_ERROR));
            return -1;
        }
        return 0;
    }

    @Nonnull
    private static CsvOutput makeCsv(BufferedWriter writer) throws IOException {
        return CsvOutput.m_13619_().m_13630_("room_x").m_13630_("room_z").m_13630_("size").m_13630_("owner_uuid").m_13630_("spawn_x").m_13630_("spawn_y").m_13630_("spawn_z").m_13628_((Writer)writer);
    }

    private static void writeRoom(CompactRoomData.RoomData room, CsvOutput builder) {
        try {
            ChunkPos chunk = new ChunkPos(room.getCenter());
            Vec3 spawn = room.getSpawn();
            builder.m_13624_(new Object[]{chunk.f_45578_, chunk.f_45579_, room.getSize().m_7912_(), room.getOwner().toString(), spawn.f_82479_, spawn.f_82480_, spawn.f_82481_});
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
        }
    }
}

