/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.packet.JumpscareSyncPacket;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class VillagerSoulEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(VillagerSoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackTicks;
    double chargeX;
    double chargeY;
    double chargeZ;
    private int oldSwell;
    private int swell;
    private final int maxSwell = 15;

    public VillagerSoulEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING, (Object)false);
    }

    public void m_8119_() {
        this.f_19794_ = true;
        this.m_20242_(true);
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
        this.m_20331_(true);
        this.oldSwell = this.swell++;
        if (this.swell >= this.maxSwell) {
            this.swell = this.maxSwell;
        }
        if (this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
        }
        if (this.isCharging()) {
            this.m_20334_(this.chargeX, this.chargeY, this.chargeZ);
        }
        if (this.m_5448_() != null) {
            ++this.attackTicks;
            if (this.attackTicks == 50) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SCREECH.get(), 3.0f, this.m_6100_());
            }
            if (this.attackTicks > 50) {
                LivingEntity entity = this.m_5448_();
                double x = this.m_20185_() - entity.m_20185_();
                double y = this.m_20186_() - entity.m_20186_();
                double z = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 6.5f;
                double motionX = -(x / d * (double)power * 0.2);
                double motionY = -(y / d * (double)power * 0.2);
                double motionZ = -(z / d * (double)power * 0.2);
                this.setCharge(motionX, motionY, motionZ);
                if (!this.m_9236_().f_46443_) {
                    this.setCharging(true);
                }
            }
            if (this.m_20280_((Entity)this.m_5448_()) < 4.0) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_JUMPSCARE.get(), 3.0f, this.m_6100_());
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.2f, 0, 40);
                this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
                LivingEntity livingEntity = this.m_5448_();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new JumpscareSyncPacket());
                }
                this.m_146870_();
            }
        }
        if (this.f_19797_ > 100) {
            this.m_146870_();
        }
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    protected boolean m_6129_() {
        return false;
    }

    public void setCharge(double x, double y, double z) {
        this.chargeX = x;
        this.chargeY = y;
        this.chargeZ = z;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.f_20919_ = 19;
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charge) {
        this.f_19804_.m_135381_(CHARGING, (Object)charge);
    }
}

