/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.client.sound.BossMusicPlayer;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.FreakagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.entities.VillagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.PumpkinBombEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.WebEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;

public class OldRagnoEntity
extends Raider
implements ICanBeAnimated {
    public ServerBossEvent bossEvent;
    private static final UUID SPEED_PENALTY_UUID = UUID.fromString("5CD17A52-AB9A-42D3-A629-90FDE04B281E");
    private static final AttributeModifier SPEED_PENALTY;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE;
    private static final EntityDataAccessor<Boolean> CRAZY;
    private static final EntityDataAccessor<Boolean> STUNNED;
    private static final EntityDataAccessor<Integer> ATTACK_TYPE;
    public AnimationState introAnimationState = new AnimationState();
    public AnimationState phaseAnimationState = new AnimationState();
    public AnimationState blockAnimationState = new AnimationState();
    public AnimationState webAnimationState = new AnimationState();
    public AnimationState leapAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();
    public AnimationState popupAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState coughAnimationState = new AnimationState();
    public AnimationState stunAnimationState = new AnimationState();
    public int attackType;
    private int attackTicks;
    private int attackCooldown;
    private final int WEB_ATTACK = 1;
    private final int LEAP_ATTACK = 2;
    private final int BURROW_ATTACK = 3;
    private final int CHARGE_ATTACK = 4;
    private final int COUGH_ATTACK = 5;
    private int webCooldown;
    private int leapCooldown;
    private int burrowCooldown;
    private int chargeCooldown;
    private int coughCooldown;
    int introTicks;
    int phaseTicks;
    private Mob owner;
    public ItemEntity item = null;
    int blockTicks;
    boolean shouldHurtOnTouch;
    public boolean isPlayingIntro;
    public double chargeX;
    public double chargeZ;
    public boolean circleDirection;
    public int circleTick;
    public int attacksUsed;
    public int stunTick;
    private boolean isBurrowing = false;
    private DamageSource lastDamageSource;
    private boolean shouldDropDisc;

    public OldRagnoEntity(EntityType<? extends Raider> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 40;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(((Boolean)Config.CommonConfig.bosses_darken_sky.get()).booleanValue());
        this.bossEvent.m_8321_(false);
    }

    public void m_6457_(ServerPlayer p_20119_) {
        super.m_6457_(p_20119_);
        this.bossEvent.m_6543_(p_20119_);
    }

    public void m_6452_(ServerPlayer p_20119_) {
        super.m_6452_(p_20119_);
        this.bossEvent.m_6539_(p_20119_);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new StunGoal());
        this.f_21345_.m_25352_(0, (Goal)new WebGoal());
        this.f_21345_.m_25352_(0, (Goal)new LeapGoal());
        this.f_21345_.m_25352_(0, (Goal)new BurrowGoal());
        this.f_21345_.m_25352_(0, (Goal)new ChargeGoal());
        this.f_21345_.m_25352_(0, (Goal)new CoughGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AlwaysWatchTargetGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean m_7327_(Entity p_21372_) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(CRAZY, (Object)false);
        this.f_19804_.m_135372_(STUNNED, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public boolean isCrazy() {
        return (Boolean)this.f_19804_.m_135370_(CRAZY);
    }

    public void setCrazy(boolean crazy) {
        this.f_19804_.m_135381_(CRAZY, (Object)crazy);
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(STUNNED);
    }

    public void setStunned(boolean stunned) {
        this.f_19804_.m_135381_(STUNNED, (Object)stunned);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
    }

    public void m_7378_(CompoundTag p_37862_) {
        super.m_7378_(p_37862_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public boolean m_37882_() {
        return (this.isCrazy() || this.phaseTicks > 0) && super.m_37882_();
    }

    public SoundEvent getTransMusic() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_TRANS.get();
    }

    public SoundEvent getBossMusic() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_MUSIC.get();
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 2500.0f;
    }

    public void m_7822_(byte id) {
        if (id == 67) {
            BossMusicPlayer.playBossMusic(this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic(this);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        if (this.isPlayingIntro) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.owner == null && this.f_19797_ > 5) {
            List list = this.m_9236_().m_45976_(FreakagerEntity.class, this.m_20191_().m_82400_(2.0));
            if (!list.isEmpty()) {
                this.owner = (Mob)list.get(this.f_19796_.m_188503_(list.size()));
            }
            if (this.owner == null && !this.m_9236_().f_46443_) {
                this.setCrazy(true);
            }
        }
        if (EntityUtil.displayBossBar(this) && this.isCrazy() && !this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(true);
        }
        if (this.getOwner() != null) {
            if (this.getOwner().m_6084_()) {
                this.m_6710_(this.getOwner().m_5448_());
            }
            if (this.getOwner().m_21224_() && this.phaseTicks < 1) {
                if (!this.m_9236_().f_46443_) {
                    this.stopAttacking();
                }
                this.isPlayingIntro = true;
                this.setAnimationState(2);
                this.phaseTicks = 1;
            }
        }
        if (!this.m_9236_().f_46443_ && this.isCrazy() && this.getBossMusic() != null) {
            if (this.canPlayMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        if (this.getAttackType() <= 0 && !this.isPlayingIntro && !this.isStunned()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(SPEED_PENALTY);
        } else {
            AttributeInstance speedAttribute = this.m_21051_(Attributes.f_22279_);
            assert (speedAttribute != null);
            speedAttribute.m_22130_(SPEED_PENALTY);
            speedAttribute.m_22118_(SPEED_PENALTY);
        }
        if (this.f_19796_.m_188503_(200) == 0) {
            this.circleDirection = !this.circleDirection;
        }
        this.circleTick += this.circleDirection ? 1 : -1;
        if (this.stunTick > 0) {
            this.m_21573_().m_26573_();
            this.f_21344_.m_26573_();
        }
        this.stopAttackersFromAttacking();
        if (this.blockTicks > 0) {
            --this.blockTicks;
        }
        if (this.introTicks > 0) {
            ++this.introTicks;
        }
        if (this.introTicks <= 80) {
            this.m_21573_().m_26573_();
            this.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
            }
            this.m_21566_().m_24988_(0.0f, 0.0f);
            this.f_21344_.m_26573_();
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.introTicks == 21) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_ROAR.get(), 3.0f, 1.0f);
        }
        if (this.introTicks == 24) {
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 48, 20);
        }
        if (this.introTicks == 70) {
            this.isPlayingIntro = false;
            this.setAnimationState(0);
        }
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (this.phaseTicks > 0) {
            ++this.phaseTicks;
        }
        if (this.phaseTicks == 19) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, 1.0f);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_EAT.get(), 2.0f, 1.0f);
        }
        if (this.phaseTicks == 20 && this.item != null) {
            this.makeSpitParticles((Entity)this.item);
            this.item.m_146870_();
        }
        if (this.phaseTicks == 27) {
            if (!this.m_9236_().f_46443_) {
                this.setCrazy(true);
            }
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.1f, 0, 20);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.0f);
        }
        if (this.phaseTicks == 43) {
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.5f);
        }
        if (this.phaseTicks == 60) {
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.4f);
        }
        if (this.phaseTicks == 50) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.7f);
        }
        if (this.phaseTicks == 80) {
            this.isPlayingIntro = false;
            this.attackTicks = 0;
            this.setAttackType(0);
            this.setAnimationState(0);
        }
        if (this.getAttackType() > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.getAttackType() < 1) {
            if (this.webCooldown > 0) {
                --this.webCooldown;
            }
            if (this.leapCooldown > 0) {
                --this.leapCooldown;
            }
            if (this.burrowCooldown > 0) {
                --this.burrowCooldown;
            }
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.coughCooldown > 0) {
                --this.coughCooldown;
            }
        }
        if (this.m_6084_()) {
            double deltaY;
            double deltaX;
            double motionZ;
            double deltaZ;
            double deltaY2;
            double deltaZ2;
            double deltaX2;
            double distance;
            double deltaY3;
            double targetZ;
            double motionY;
            double motionZ2;
            double motionY2;
            double motionX;
            int i;
            if (this.getAttackType() == this.WEB_ATTACK && this.isCrazy()) {
                LivingEntity entity = this.m_5448_();
                if (this.attackTicks == 4) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.5, 0.0));
                }
                if (this.attackTicks == 6 && entity != null) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get(), 2.0f, 1.0f);
                    for (i = 0; i < 8; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        WebEntity projectile = (WebEntity)((EntityType)ModEntityTypes.Web.get()).m_20615_(this.m_9236_());
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - entity.m_20185_();
                        double y = projectile.m_20186_() - (entity.m_20186_() + 1.5);
                        double z = projectile.m_20189_() - entity.m_20189_();
                        double distance2 = Math.sqrt(x * x + y * y + z * z);
                        float power = 2.5f;
                        motionX = -(x / distance2 * (double)power * 0.2);
                        motionY2 = -(y / distance2 * (double)power * 0.2);
                        motionZ2 = -(z / distance2 * (double)power * 0.2);
                        double randomX = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomY = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomZ = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        projectile.setAcceleration(motionX + randomX, motionY2 + randomY, motionZ2 + randomZ);
                        projectile.setShooter((Mob)this);
                        this.m_9236_().m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks == 10) {
                    this.m_20334_(0.0, -1.0, 0.0);
                }
            }
            if (this.introTicks > 80 && !this.isCrazy() && (this.doesAttackMeetNormalRequirements() && this.f_19796_.m_188503_(16) == 0 && this.webCooldown < 1 || this.getAttackType() == this.WEB_ATTACK)) {
                if (this.attackTicks == 0) {
                    this.setAnimationState(4);
                    this.setAttackType(this.WEB_ATTACK);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                if (this.attackTicks == 6 && this.m_5448_() != null) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get(), 2.0f, 1.0f);
                    for (int i2 = 0; i2 < 8; ++i2) {
                        if (this.m_9236_().f_46443_) continue;
                        WebEntity projectile = (WebEntity)((EntityType)ModEntityTypes.Web.get()).m_20615_(this.m_9236_());
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - this.m_5448_().m_20185_();
                        double y = projectile.m_20186_() - (this.m_5448_().m_20186_() + 1.5);
                        double z = projectile.m_20189_() - this.m_5448_().m_20189_();
                        double distance3 = Math.sqrt(x * x + y * y + z * z);
                        float power = 2.5f;
                        double motionX2 = -(x / distance3 * (double)power * 0.2);
                        double motionY3 = -(y / distance3 * (double)power * 0.2);
                        double motionZ3 = -(z / distance3 * (double)power * 0.2);
                        double randomX = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomY = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomZ = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        projectile.setAcceleration(motionX2 + randomX, motionY3 + randomY, motionZ3 + randomZ);
                        projectile.setShooter((Mob)this);
                        this.m_9236_().m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks > 17) {
                    if (!this.isPlayingIntro) {
                        this.setAnimationState(0);
                    }
                    this.attackTicks = 0;
                    this.setAttackType(0);
                    this.webCooldown = 200;
                    this.attackCooldown = 20;
                }
            }
            if (this.getAttackType() == this.LEAP_ATTACK && this.isCrazy()) {
                LivingEntity target = this.m_5448_();
                double targetX = 0.0;
                motionY = 0.0;
                targetZ = 0.0;
                if (target != null) {
                    double deltaX3 = this.m_20185_() - target.m_20185_();
                    deltaY3 = this.m_20186_() - (target.m_20186_() + 1.5);
                    double deltaZ3 = this.m_20189_() - target.m_20189_();
                    distance = Math.sqrt(deltaX3 * deltaX3 + deltaY3 * deltaY3 + deltaZ3 * deltaZ3);
                    float power = 6.5f;
                    targetX = -(deltaX3 / distance * (double)power * 0.2);
                    motionY = -(deltaY3 / distance * (double)power * 0.02);
                    targetZ = -(deltaZ3 / distance * (double)power * 0.2);
                }
                if (this.attackTicks == 6) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.attackTicks == 17) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.attackTicks == 30) {
                    this.shouldHurtOnTouch = true;
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, this.m_6100_());
                    this.m_20334_(targetX, motionY > 0.0 ? motionY + 0.2 : 0.2, targetZ);
                }
                if (this.shouldHurtOnTouch) {
                    for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_()) continue;
                        deltaX2 = this.m_20185_() - entity.m_20185_();
                        double deltaY4 = this.m_20186_() - entity.m_20186_();
                        deltaZ2 = this.m_20189_() - entity.m_20189_();
                        double distance4 = Math.sqrt(deltaX2 * deltaX2 + deltaY4 * deltaY4 + deltaZ2 * deltaZ2);
                        if (!(this.m_20280_(entity) < 9.0)) continue;
                        if (entity.f_19802_ <= 0) {
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                            entity.f_19864_ = true;
                            entity.m_20334_(-deltaX2 / distance4 * 2.0, -deltaY4 / distance4 * 2.0 + 0.5, -deltaZ2 / distance4 * 2.0);
                        }
                        if (!((LivingEntity)entity).m_21254_()) continue;
                        EntityUtil.disableShield((LivingEntity)entity, 100);
                    }
                }
            }
            if (this.introTicks > 80 && !this.isCrazy() && (this.doesAttackMeetNormalRequirements() && this.f_19796_.m_188503_(16) == 0 && this.leapCooldown < 1 && this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) < 12.0 || this.getAttackType() == this.LEAP_ATTACK)) {
                if (this.attackTicks == 0) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 1.0f);
                    this.setAnimationState(5);
                    this.setAttackType(this.LEAP_ATTACK);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                LivingEntity target = this.m_5448_();
                double targetX = 0.0;
                motionY = 0.0;
                targetZ = 0.0;
                if (target != null) {
                    double deltaX4 = this.m_20185_() - target.m_20185_();
                    deltaY3 = this.m_20186_() - (target.m_20186_() + 1.5);
                    double deltaZ4 = this.m_20189_() - target.m_20189_();
                    distance = Math.sqrt(deltaX4 * deltaX4 + deltaY3 * deltaY3 + deltaZ4 * deltaZ4);
                    float power = 6.5f;
                    targetX = -(deltaX4 / distance * (double)power * 0.2);
                    motionY = -(deltaY3 / distance * (double)power * 0.02);
                    targetZ = -(deltaZ4 / distance * (double)power * 0.2);
                }
                if (this.attackTicks == 6) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.attackTicks == 17) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.attackTicks == 30) {
                    this.shouldHurtOnTouch = true;
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, this.m_6100_());
                    this.m_20334_(targetX, motionY > 0.0 ? motionY + 0.2 : 0.2, targetZ);
                }
                if (this.shouldHurtOnTouch) {
                    for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_()) continue;
                        deltaX2 = this.m_20185_() - entity.m_20185_();
                        double deltaY5 = this.m_20186_() - entity.m_20186_();
                        deltaZ2 = this.m_20189_() - entity.m_20189_();
                        double distance5 = Math.sqrt(deltaX2 * deltaX2 + deltaY5 * deltaY5 + deltaZ2 * deltaZ2);
                        if (!(this.m_20280_(entity) < 9.0)) continue;
                        if (entity.f_19802_ <= 0) {
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                            entity.f_19864_ = true;
                            entity.m_20334_(-deltaX2 / distance5 * 2.0, -deltaY5 / distance5 * 2.0 + 0.5, -deltaZ2 / distance5 * 2.0);
                        }
                        if (!((LivingEntity)entity).m_21254_()) continue;
                        EntityUtil.disableShield((LivingEntity)entity, 100);
                    }
                }
                if (this.attackTicks >= 130) {
                    if (!this.isPlayingIntro) {
                        this.setAnimationState(0);
                    }
                    this.attackTicks = 0;
                    this.setAttackType(0);
                    this.shouldHurtOnTouch = false;
                    this.leapCooldown = 100;
                    this.attackCooldown = 20;
                }
                if ((this.attackTicks > 40 && this.m_20096_() || this.getAttackType() != this.LEAP_ATTACK) && this.shouldHurtOnTouch) {
                    if (!this.isPlayingIntro) {
                        this.setAnimationState(0);
                    }
                    this.attackTicks = 0;
                    this.setAttackType(0);
                    this.shouldHurtOnTouch = false;
                    this.leapCooldown = 100;
                    this.attackCooldown = 20;
                }
            }
            if (this.getAttackType() == this.BURROW_ATTACK) {
                if (this.attackTicks > 6 && this.attackTicks <= 30) {
                    this.m_5496_(SoundEvents.f_11993_, 2.0f, 0.7f);
                    this.makeBlockParticles(this.m_20075_());
                    this.isBurrowing = true;
                }
                if (this.attackTicks >= 30 && this.m_5448_() != null) {
                    this.m_20095_();
                    if (this.attackTicks < 100) {
                        this.m_5496_(SoundEvents.f_12442_, 2.0f, 0.5f);
                    }
                    LivingEntity target = this.m_5448_();
                    double posX = this.m_20185_();
                    double posY = this.m_20186_();
                    double posZ = this.m_20189_();
                    if (this.attackTicks < 100) {
                        this.m_6842_(true);
                        posX = target.m_20185_();
                        posY = target.m_20186_();
                        posZ = target.m_20189_();
                    }
                    this.m_6034_(posX, posY, posZ);
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (this.attackTicks == 120) {
                        this.makeBlockParticles(this.m_20075_());
                        this.setAnimationState(7);
                        this.m_6842_(false);
                        CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.6f);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.2f);
                        for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                            if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_() || entity == this) continue;
                            deltaX2 = this.m_20185_() - entity.m_20185_();
                            double deltaY6 = this.m_20186_() - entity.m_20186_();
                            deltaZ2 = this.m_20189_() - entity.m_20189_();
                            double distance6 = Math.sqrt(deltaX2 * deltaX2 + deltaY6 * deltaY6 + deltaZ2 * deltaZ2);
                            if (!(this.m_20280_(entity) < 9.0) || entity.f_19802_ > 0) continue;
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                            entity.f_19864_ = true;
                            entity.m_20334_(-deltaX2 / distance6 * 2.0, -deltaY6 / distance6 * 2.0 + 0.8, -deltaZ2 / distance6 * 2.0);
                            entity.m_6001_(-deltaX2 / distance6 * 2.0, -deltaY6 / distance6 * 2.0 + 0.8, -deltaZ2 / distance6 * 2.0);
                        }
                        this.m_20334_(0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.isCrazy() && this.getAttackType() == this.CHARGE_ATTACK) {
                LivingEntity target = this.m_5448_();
                if (this.attackTicks == 30 && target != null) {
                    double deltaX5 = this.m_20185_() - target.m_20185_();
                    deltaY2 = this.m_20186_() - target.m_20186_();
                    deltaZ = this.m_20189_() - target.m_20189_();
                    double distance7 = Math.sqrt(deltaX5 * deltaX5 + deltaY2 * deltaY2 + deltaZ * deltaZ);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CHARGE.get(), 2.0f, this.m_6100_());
                    float power = 4.5f;
                    double motionX3 = -(deltaX5 / distance7 * (double)power * 0.2);
                    motionZ = -(deltaZ / distance7 * (double)power * 0.2);
                    this.chargeX = motionX3;
                    this.chargeZ = motionZ;
                }
                if (this.attackTicks > 30) {
                    this.m_20334_(this.chargeX, this.m_20184_().f_82480_, this.chargeZ);
                    for (Entity hit : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(hit, (Mob)this) || !(hit instanceof LivingEntity) || !hit.m_6084_() || hit == this) continue;
                        deltaX = this.m_20185_() - hit.m_20185_();
                        deltaY = this.m_20186_() - hit.m_20186_();
                        double deltaZ5 = this.m_20189_() - hit.m_20189_();
                        double distance8 = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ5 * deltaZ5);
                        if (!(this.m_20280_(hit) < 9.0) || hit.f_19802_ > 0) continue;
                        this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                        hit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                        hit.f_19864_ = true;
                        hit.m_20334_(-deltaX / distance8 * 2.0, -deltaY / distance8 * 2.0 + 1.2, -deltaZ5 / distance8 * 2.0);
                        hit.m_6001_(-deltaX / distance8 * 2.0, -deltaY / distance8 * 2.0 + 1.2, -deltaZ5 / distance8 * 2.0);
                    }
                }
            }
            if (this.introTicks > 80 && !this.isCrazy() && (this.doesAttackMeetNormalRequirements() && this.m_20280_((Entity)this.m_5448_()) > 1225.0 && this.chargeCooldown < 1 || this.getAttackType() == 4)) {
                if (this.attackTicks == 0) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.9f);
                    this.setAnimationState(8);
                    this.setAttackType(this.CHARGE_ATTACK);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                LivingEntity target = this.m_5448_();
                if (this.attackTicks == 30 && target != null) {
                    double deltaX6 = this.m_20185_() - target.m_20185_();
                    deltaY2 = this.m_20186_() - target.m_20186_();
                    deltaZ = this.m_20189_() - target.m_20189_();
                    double distance9 = Math.sqrt(deltaX6 * deltaX6 + deltaY2 * deltaY2 + deltaZ * deltaZ);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CHARGE.get(), 2.0f, this.m_6100_());
                    float power = 4.5f;
                    double motionX4 = -(deltaX6 / distance9 * (double)power * 0.2);
                    motionZ = -(deltaZ / distance9 * (double)power * 0.2);
                    this.chargeX = motionX4;
                    this.chargeZ = motionZ;
                }
                if (this.attackTicks > 30) {
                    this.m_20334_(this.chargeX, this.m_20184_().f_82480_, this.chargeZ);
                    for (Entity hit : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(hit, (Mob)this) || !(hit instanceof LivingEntity) || !hit.m_6084_() || hit == this) continue;
                        deltaX = this.m_20185_() - hit.m_20185_();
                        deltaY = this.m_20186_() - hit.m_20186_();
                        double deltaZ6 = this.m_20189_() - hit.m_20189_();
                        double distance10 = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ6 * deltaZ6);
                        if (!(this.m_20280_(hit) < 9.0) || hit.f_19802_ > 0) continue;
                        this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                        hit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                        hit.f_19864_ = true;
                        hit.m_20334_(-deltaX / distance10 * 2.0, -deltaY / distance10 * 2.0 + 1.2, -deltaZ6 / distance10 * 2.0);
                        hit.m_6001_(-deltaX / distance10 * 2.0, -deltaY / distance10 * 2.0 + 1.2, -deltaZ6 / distance10 * 2.0);
                    }
                }
                if (this.attackTicks > 100 || !((Entity)this.m_20197_().get(0)).m_6084_()) {
                    this.setAnimationState(0);
                    this.attackTicks = 0;
                    this.setAttackType(0);
                    this.chargeCooldown = 40;
                    this.attackCooldown = 20;
                }
            }
            if (this.getAttackType() == this.COUGH_ATTACK && this.attackTicks == 10 && this.m_5448_() != null) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_COUGH.get(), 2.0f, 1.0f);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.06f, 0, 10);
                LivingEntity target = this.m_5448_();
                if (this.f_19796_.m_188499_()) {
                    for (i = 0; i < 4; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        TrickOrTreatEntity treat = (TrickOrTreatEntity)((EntityType)ModEntityTypes.TrickOrTreat.get()).m_20615_(this.m_9236_());
                        assert (treat != null);
                        treat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        deltaX = this.m_20185_() - target.m_20185_();
                        deltaY = this.m_20186_() - target.m_20186_();
                        double deltaZ7 = this.m_20189_() - target.m_20189_();
                        double distance11 = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ7 * deltaZ7);
                        float power = 4.5f;
                        motionX = -(deltaX / distance11 * (double)power * 0.2);
                        motionY2 = -(deltaY / distance11 * (double)power * 0.2);
                        motionZ2 = -(deltaZ7 / distance11 * (double)power * 0.2);
                        treat.m_20334_(motionX, motionY2, motionZ2);
                        treat.circleTime = i * 10;
                        treat.bounceTime = i;
                        treat.setTreat(this.f_19796_.m_188503_(5) + 1);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(treat.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        Objects.requireNonNull(treat.m_21051_(Attributes.f_22276_)).m_22100_(12.0);
                        treat.m_5634_(50.0f);
                        treat.setOwner((LivingEntity)this);
                        treat.setGoopy();
                        treat.setOld(true);
                        this.m_9236_().m_7967_((Entity)treat);
                    }
                } else {
                    for (i = 0; i < 3; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        PumpkinBombEntity treat = (PumpkinBombEntity)((EntityType)ModEntityTypes.PumpkinBomb.get()).m_20615_(this.m_9236_());
                        assert (treat != null);
                        treat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        deltaX = this.m_20185_() - target.m_20185_();
                        deltaY = this.m_20186_() - target.m_20186_();
                        double deltaZ8 = this.m_20189_() - target.m_20189_();
                        double distance12 = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ8 * deltaZ8);
                        float power = 4.5f;
                        motionX = -(deltaX / distance12 * (double)power * 0.2);
                        motionY2 = -(deltaY / distance12 * (double)power * 0.2);
                        motionZ2 = -(deltaZ8 / distance12 * (double)power * 0.2);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(treat.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        treat.m_20334_(motionX, motionY2, motionZ2);
                        treat.setOwner((LivingEntity)this);
                        treat.m_6710_(this.m_5448_());
                        treat.setGoopy();
                        this.m_9236_().m_7967_((Entity)treat);
                    }
                }
            }
        }
        if (this.attackType == 0 && !this.isPlayingIntro && this.m_5448_() != null && !this.isStunned()) {
            this.circleTarget((Entity)this.m_5448_(), 10.0f, 0.8f, true, this.circleTick, 0.0f, 1.0f);
            this.m_21391_((Entity)this.m_5448_(), 100.0f, 100.0f);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
        }
        if (this.attacksUsed >= 4 && !this.isStunned()) {
            this.setStunned(true);
        }
        if (this.isStunned()) {
            this.m_21573_().m_26573_();
            ++this.stunTick;
            if (this.stunTick == 6) {
                this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_STUN.get(), 3.0f, 1.0f);
            }
            if (this.stunTick % 5 == 0) {
                this.makeSweatParticles();
            }
            this.f_21344_.m_26573_();
        }
        if (this.m_5448_() != null && this.m_6084_() && (double)this.m_20270_((Entity)this.m_5448_()) < 8.0 * ((double)this.m_5448_().m_20205_() + 0.4) && this.getAttackType() == 0 && this.m_20096_() && !this.isStunned() && !this.isPlayingIntro) {
            double deltaX = this.m_20185_() - this.m_5448_().m_20185_();
            double deltaY = this.m_20186_() - this.m_5448_().m_20186_();
            double deltaZ = this.m_20189_() - this.m_5448_().m_20189_();
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            this.m_20256_(this.m_20184_().m_82492_(-deltaX / distance * 0.08, 0.0, -deltaZ / distance * 0.08));
        }
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attackType) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attackType);
    }

    public void stopAttacking() {
        this.setAttackType(0);
    }

    public void m_7334_(Entity p_21294_) {
        if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 6) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_6138_() {
        if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 6) {
            super.m_6138_();
        }
    }

    public void m_6667_(DamageSource source) {
        List treats = this.m_9236_().m_45976_(TrickOrTreatEntity.class, this.m_20191_().m_82400_(40.0));
        if (!treats.isEmpty()) {
            for (TrickOrTreatEntity treat : treats) {
                if (treat.getOwner() != this) continue;
                treat.m_6074_();
            }
        }
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().f_37673_ = 0L;
        }
        if (!this.isStunned()) {
            this.shouldDropDisc = true;
        }
        this.m_20095_();
        if (!this.m_9236_().f_46443_) {
            this.attackTicks = 0;
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        }
        if (this.f_20889_ > 0) {
            this.f_20889_ = 10000;
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 100) {
            VillagerSoulEntity soul = (VillagerSoulEntity)((EntityType)ModEntityTypes.VillagerSoul.get()).m_20615_(this.m_9236_());
            assert (soul != null);
            soul.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            soul.m_20334_(0.0, 0.3, 0.0);
            soul.m_6710_(this.m_21188_());
            this.m_9236_().m_7967_((Entity)soul);
        }
        if (this.f_20919_ == 200 && !this.m_9236_().m_5776_()) {
            super.m_6667_(this.lastDamageSource != null ? this.lastDamageSource : this.m_269291_().m_269264_());
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_6668_(DamageSource source) {
        if (this.m_6125_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) && source.m_7639_() instanceof Player && this.shouldDropDisc) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemRegisterer.FREAKAGER_DISC.get())));
        }
        super.m_6668_(source);
    }

    public boolean m_5825_() {
        return super.m_5825_() && !this.m_21224_();
    }

    public void makeSpitParticles(Entity caught) {
        if (!this.m_9236_().f_46443_) {
            Iterator var2 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var2.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var2.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 12; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123769_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    private void circleTarget(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        if (!this.isStunned()) {
            int directionInt = 1;
            double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
            Vec3 movePos = target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
            this.m_21573_().m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), (double)(speed * moveSpeedMultiplier));
        }
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CRAWL.get(), 0.5f, 1.0f);
    }

    public void makeBlockParticles(BlockState blockstate) {
        if (!this.m_9236_().f_46443_) {
            Iterator var2 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var2.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var2.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 12; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    BlockParticleOption block = new BlockParticleOption(ParticleTypes.f_123794_, blockstate);
                    packet.queueParticle((ParticleOptions)block, false, new Vec3(this.m_20208_(0.5), this.m_20186_(), this.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeSweatParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 2; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123769_, false, new Vec3(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    public void stopAttackersFromAttacking() {
        List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        if (this.getOwner() != null && this.getOwner().m_6084_()) {
            for (Mob attacker : list) {
                if (attacker.m_21188_() == this && this.getOwner() != null) {
                    attacker.m_6703_((LivingEntity)this.getOwner());
                }
                if (attacker.m_5448_() == this && this.getOwner() != null) {
                    attacker.m_6710_((LivingEntity)this.getOwner());
                }
                Mob owner = this.getOwner();
                if (attacker instanceof Warden) {
                    Warden warden = (Warden)attacker;
                    if (warden.m_5448_() != this) continue;
                    warden.m_219387_((Entity)owner, AngerLevel.ANGRY.m_219226_() + 100, false);
                    warden.m_219459_((LivingEntity)owner);
                    continue;
                }
                try {
                    if (!attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)owner.m_20148_(), 600L);
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)owner, 600L);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public boolean m_20329_(Entity p_20330_) {
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.getOwner() != null && damageSource.m_7639_() == this.getOwner()) {
            return false;
        }
        if (this.isBurrowing) {
            return false;
        }
        if (this.m_6084_() && !damageSource.m_276093_(DamageTypes.f_268724_) && !damageSource.m_276093_(DamageTypes.f_286979_) && OldRagnoEntity.isMobNotInCreativeMode(damageSource.m_7639_())) {
            if (!this.isCrazy()) {
                boolean source;
                boolean bl = source = !damageSource.m_269533_(DamageTypeTags.f_268490_);
                if (source && this.blockTicks < 1 && ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 0 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 3)) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
                    this.setAnimationState(0);
                    this.setAnimationState(3);
                    this.blockTicks = 10;
                }
                if (damageSource.m_7639_() instanceof LivingEntity && this.m_21188_() == null) {
                    this.m_6703_((LivingEntity)damageSource.m_7639_());
                }
                return false;
            }
            if (!this.isStunned()) {
                boolean source;
                boolean bl = source = !damageSource.m_269533_(DamageTypeTags.f_268490_);
                if (source && this.getAttackType() == 0) {
                    if (this.blockTicks < 1 && ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 0 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 3)) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
                        this.setAnimationState(0);
                        this.setAnimationState(3);
                        this.blockTicks = 10;
                    }
                    if (damageSource.m_7639_() instanceof LivingEntity && this.m_21188_() == null) {
                        this.m_6703_((LivingEntity)damageSource.m_7639_());
                    }
                    return false;
                }
                amount /= 3.5f;
            }
        }
        this.lastDamageSource = damageSource;
        return !damageSource.m_276093_(DamageTypes.f_268612_) && super.m_6469_(damageSource, amount);
    }

    public static boolean isMobNotInCreativeMode(Entity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        return !((Player)entity).m_7500_() && !entity.m_5833_();
    }

    public SoundEvent m_7930_() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 6 ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 6 ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_DEATH.get();
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    public double m_6048_() {
        return 2.5;
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "intro")) {
            return this.introAnimationState;
        }
        if (Objects.equals(input, "phase")) {
            return this.phaseAnimationState;
        }
        if (Objects.equals(input, "block")) {
            return this.blockAnimationState;
        }
        if (Objects.equals(input, "web")) {
            return this.webAnimationState;
        }
        if (Objects.equals(input, "leap")) {
            return this.leapAnimationState;
        }
        if (Objects.equals(input, "burrow")) {
            return this.burrowAnimationState;
        }
        if (Objects.equals(input, "popup")) {
            return this.popupAnimationState;
        }
        if (Objects.equals(input, "charge")) {
            return this.chargeAnimationState;
        }
        if (Objects.equals(input, "cough")) {
            return this.coughAnimationState;
        }
        return Objects.equals(input, "stun") ? this.stunAnimationState : new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.introAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.phaseAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.blockAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.webAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.leapAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.popupAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.chargeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.coughAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.stunAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.phaseAnimationState.m_216973_();
        this.blockAnimationState.m_216973_();
        this.webAnimationState.m_216973_();
        this.leapAnimationState.m_216973_();
        this.burrowAnimationState.m_216973_();
        this.popupAnimationState.m_216973_();
        this.chargeAnimationState.m_216973_();
        this.coughAnimationState.m_216973_();
        this.stunAnimationState.m_216973_();
    }

    public void playIntro() {
        this.setAnimationState(1);
        this.introTicks = 1;
        this.isPlayingIntro = true;
    }

    public void setAnimationState(int input) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.getAttackType() == 0 && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.attackCooldown < 1 && !this.isStunned() && !this.isPlayingIntro;
    }

    static {
        ANIMATION_STATE = SynchedEntityData.m_135353_(OldRagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CRAZY = SynchedEntityData.m_135353_(OldRagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        STUNNED = SynchedEntityData.m_135353_(OldRagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        ATTACK_TYPE = SynchedEntityData.m_135353_(OldRagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_FLAGS_ID = SynchedEntityData.m_135353_(OldRagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        SPEED_PENALTY = new AttributeModifier(SPEED_PENALTY_UUID, "STOP MOVING AROUND STUPID", -0.35, AttributeModifier.Operation.ADDITION);
    }

    class StunGoal
    extends Goal {
        public StunGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldRagnoEntity.this.isStunned();
        }

        public void m_8056_() {
            OldRagnoEntity.this.setAnimationState(10);
        }

        public boolean m_8045_() {
            return OldRagnoEntity.this.stunTick <= 100;
        }

        public void m_8037_() {
            OldRagnoEntity.this.m_21573_().m_26573_();
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (OldRagnoEntity.this.m_5448_() != null) {
                OldRagnoEntity.this.m_21563_().m_24960_((Entity)OldRagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            OldRagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            OldRagnoEntity.this.setAnimationState(0);
            OldRagnoEntity.this.attackTicks = 0;
            OldRagnoEntity.this.setAttackType(0);
            OldRagnoEntity.this.attackCooldown = 40;
            OldRagnoEntity.this.attacksUsed = 0;
            OldRagnoEntity.this.stunTick = 0;
            OldRagnoEntity.this.setStunned(false);
        }
    }

    class WebGoal
    extends Goal {
        public WebGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldRagnoEntity.this.doesAttackMeetNormalRequirements() && OldRagnoEntity.this.f_19796_.m_188503_(16) == 0 && OldRagnoEntity.this.webCooldown < 1;
        }

        public void m_8056_() {
            OldRagnoEntity.this.setAnimationState(4);
            OldRagnoEntity.this.setAttackType(OldRagnoEntity.this.WEB_ATTACK);
        }

        public boolean m_8045_() {
            return OldRagnoEntity.this.attackTicks <= 17 && OldRagnoEntity.this.getAttackType() == OldRagnoEntity.this.WEB_ATTACK;
        }

        public void m_8037_() {
            OldRagnoEntity.this.m_21573_().m_26573_();
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (OldRagnoEntity.this.m_5448_() != null) {
                OldRagnoEntity.this.m_21563_().m_24960_((Entity)OldRagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            OldRagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            if (!OldRagnoEntity.this.isPlayingIntro) {
                OldRagnoEntity.this.setAnimationState(0);
            }
            OldRagnoEntity.this.attackTicks = 0;
            OldRagnoEntity.this.setAttackType(0);
            OldRagnoEntity.this.webCooldown = 200;
            OldRagnoEntity.this.attackCooldown = 20;
            if (OldRagnoEntity.this.isCrazy()) {
                ++OldRagnoEntity.this.attacksUsed;
            }
        }
    }

    class LeapGoal
    extends Goal {
        public LeapGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldRagnoEntity.this.doesAttackMeetNormalRequirements() && OldRagnoEntity.this.f_19796_.m_188503_(16) == 0 && OldRagnoEntity.this.leapCooldown < 1 && OldRagnoEntity.this.m_5448_() != null && (double)OldRagnoEntity.this.m_20270_((Entity)OldRagnoEntity.this.m_5448_()) < 12.0;
        }

        public void m_8056_() {
            OldRagnoEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 1.0f);
            OldRagnoEntity.this.setAnimationState(5);
            OldRagnoEntity.this.setAttackType(OldRagnoEntity.this.LEAP_ATTACK);
        }

        public boolean m_8045_() {
            if (OldRagnoEntity.this.attackTicks >= 130) {
                return false;
            }
            return (OldRagnoEntity.this.attackTicks <= 40 || !OldRagnoEntity.this.m_20096_()) && OldRagnoEntity.this.getAttackType() == OldRagnoEntity.this.LEAP_ATTACK;
        }

        public void m_8037_() {
            OldRagnoEntity.this.m_21573_().m_26573_();
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (OldRagnoEntity.this.m_5448_() != null) {
                OldRagnoEntity.this.m_21563_().m_24960_((Entity)OldRagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            OldRagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            if (!OldRagnoEntity.this.isPlayingIntro) {
                OldRagnoEntity.this.setAnimationState(0);
            }
            OldRagnoEntity.this.attackTicks = 0;
            OldRagnoEntity.this.setAttackType(0);
            OldRagnoEntity.this.shouldHurtOnTouch = false;
            OldRagnoEntity.this.leapCooldown = 100;
            OldRagnoEntity.this.attackCooldown = 20;
            if (OldRagnoEntity.this.isCrazy()) {
                ++OldRagnoEntity.this.attacksUsed;
            }
        }
    }

    class BurrowGoal
    extends Goal {
        public BurrowGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldRagnoEntity.this.doesAttackMeetNormalRequirements() && OldRagnoEntity.this.f_19796_.m_188503_(16) == 0 && OldRagnoEntity.this.burrowCooldown < 1 && OldRagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            OldRagnoEntity.this.setAnimationState(6);
            OldRagnoEntity.this.setAttackType(OldRagnoEntity.this.BURROW_ATTACK);
        }

        public boolean m_8045_() {
            return OldRagnoEntity.this.attackTicks <= 138;
        }

        public void m_8037_() {
            OldRagnoEntity.this.m_21573_().m_26573_();
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (OldRagnoEntity.this.m_5448_() != null) {
                OldRagnoEntity.this.m_21563_().m_24960_((Entity)OldRagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            OldRagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            OldRagnoEntity.this.setAnimationState(0);
            OldRagnoEntity.this.attackTicks = 0;
            OldRagnoEntity.this.setAttackType(0);
            OldRagnoEntity.this.burrowCooldown = 160;
            OldRagnoEntity.this.attackCooldown = 20;
            ++OldRagnoEntity.this.attacksUsed;
            OldRagnoEntity.this.m_6842_(false);
            OldRagnoEntity.this.isBurrowing = false;
        }
    }

    class ChargeGoal
    extends Goal {
        public ChargeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldRagnoEntity.this.doesAttackMeetNormalRequirements() && OldRagnoEntity.this.f_19796_.m_188503_(16) == 0 && OldRagnoEntity.this.chargeCooldown < 1 && OldRagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            OldRagnoEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.9f);
            OldRagnoEntity.this.setAnimationState(8);
            OldRagnoEntity.this.setAttackType(OldRagnoEntity.this.CHARGE_ATTACK);
        }

        public boolean m_8045_() {
            return OldRagnoEntity.this.attackTicks <= 70;
        }

        public void m_8037_() {
            OldRagnoEntity.this.m_21573_().m_26573_();
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (OldRagnoEntity.this.m_5448_() != null) {
                OldRagnoEntity.this.m_21563_().m_24960_((Entity)OldRagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            OldRagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            OldRagnoEntity.this.setAnimationState(0);
            OldRagnoEntity.this.attackTicks = 0;
            OldRagnoEntity.this.setAttackType(0);
            OldRagnoEntity.this.chargeCooldown = 160;
            OldRagnoEntity.this.attackCooldown = 20;
            ++OldRagnoEntity.this.attacksUsed;
        }
    }

    class CoughGoal
    extends Goal {
        public CoughGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldRagnoEntity.this.doesAttackMeetNormalRequirements() && OldRagnoEntity.this.f_19796_.m_188503_(16) == 0 && OldRagnoEntity.this.coughCooldown < 1 && OldRagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            OldRagnoEntity.this.setAnimationState(9);
            OldRagnoEntity.this.setAttackType(OldRagnoEntity.this.COUGH_ATTACK);
        }

        public boolean m_8045_() {
            return OldRagnoEntity.this.attackTicks <= 70;
        }

        public void m_8037_() {
            OldRagnoEntity.this.m_21573_().m_26573_();
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (OldRagnoEntity.this.m_5448_() != null) {
                OldRagnoEntity.this.m_21563_().m_24960_((Entity)OldRagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            OldRagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            OldRagnoEntity.this.setAnimationState(0);
            OldRagnoEntity.this.attackTicks = 0;
            OldRagnoEntity.this.setAttackType(0);
            OldRagnoEntity.this.coughCooldown = 200;
            OldRagnoEntity.this.attackCooldown = 20;
            ++OldRagnoEntity.this.attacksUsed;
        }
    }

    class AlwaysWatchTargetGoal
    extends Goal {
        public AlwaysWatchTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return OldRagnoEntity.this.isPlayingIntro;
        }

        public boolean m_8045_() {
            return OldRagnoEntity.this.isPlayingIntro;
        }

        public void m_8037_() {
            OldRagnoEntity.this.m_21573_().m_26573_();
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (OldRagnoEntity.this.m_5448_() != null) {
                OldRagnoEntity.this.m_21563_().m_24960_((Entity)OldRagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldRagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            OldRagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            OldRagnoEntity.this.isPlayingIntro = false;
            OldRagnoEntity.this.setAnimationState(0);
        }
    }
}

