/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.model.RagnoModel;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RagnoRenderer
extends MobRenderer<RagnoEntity, RagnoModel<RagnoEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/ragno.png");
    private static final ResourceLocation PAIN = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/pain.png");
    private static final ResourceLocation SCREAM = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/scream.png");
    private static final ResourceLocation INSANE = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/insane.png");
    private static final ResourceLocation WOUNDED = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/wounded.png");
    private static final ResourceLocation TEXTURE_ARACH = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/arachnophobe/ragno.png");
    private static final ResourceLocation PAIN_ARACH = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/arachnophobe/pain.png");
    private static final ResourceLocation SCREAM_ARACH = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/arachnophobe/scream.png");
    private static final ResourceLocation WOUNDED_ARACH = new ResourceLocation("illageandspillage", "textures/entity/freakager/ragno/arachnophobe/wounded.png");

    public RagnoRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new RagnoModel(renderManagerIn.m_174023_(RagnoModel.LAYER_LOCATION)), 1.6f);
    }

    public Vec3 getRenderOffset(RagnoEntity p_114336_, float p_114337_) {
        float craziness = (float)p_114336_.getShakeMultiplier() / 10.0f;
        return new Vec3(p_114336_.m_217043_().m_188583_() * 0.02 * (double)craziness, 0.0, p_114336_.m_217043_().m_188583_() * 0.02 * (double)craziness);
    }

    protected float getFlipDegrees(RagnoEntity p_115337_) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(RagnoEntity p_110775_1_) {
        return switch (p_110775_1_.getRagnoFace()) {
            case 1 -> {
                if (((Boolean)Config.ClientConfig.arachnophobeMode.get()).booleanValue()) {
                    yield PAIN_ARACH;
                }
                yield PAIN;
            }
            case 2 -> {
                if (((Boolean)Config.ClientConfig.arachnophobeMode.get()).booleanValue()) {
                    yield SCREAM_ARACH;
                }
                yield SCREAM;
            }
            case 3 -> {
                if (((Boolean)Config.ClientConfig.arachnophobeMode.get()).booleanValue()) {
                    yield SCREAM_ARACH;
                }
                yield INSANE;
            }
            case 4 -> {
                if (((Boolean)Config.ClientConfig.arachnophobeMode.get()).booleanValue()) {
                    yield WOUNDED_ARACH;
                }
                yield WOUNDED;
            }
            default -> (Boolean)Config.ClientConfig.arachnophobeMode.get() != false ? TEXTURE_ARACH : TEXTURE;
        };
    }
}

