/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsarmor.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xjqsh.lesraisinsarmor.armor.AbstractArmorMaterial;
import me.xjqsh.lesraisinsarmor.armor.LrArmorMaterial;
import me.xjqsh.lesraisinsarmor.client.renderer.BedrockArmorRenderer;
import me.xjqsh.lesraisinsarmor.config.CommonConfig;
import me.xjqsh.lesraisinsarmor.resource.ArmorDataManager;
import me.xjqsh.lesraisinsarmor.resource.data.ArmorData;
import me.xjqsh.lesraisinsarmor.resource.data.ArmorPartData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LrArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String suitIdf;
    @Nullable
    private final Supplier<MobEffect> suitEffect;
    private ArmorData armorData;
    private ArmorMaterial material;

    public Rarity m_41460_(ItemStack pStack) {
        return super.m_41460_(pStack);
    }

    public LrArmorItem(String suitIdf, ArmorItem.Type slot, Item.Properties properties, @Nullable Supplier<MobEffect> suitEffect) {
        super((ArmorMaterial)LrArmorMaterial.DEFAULT, slot, properties);
        this.suitIdf = suitIdf;
        this.suitEffect = suitEffect;
    }

    public String getSuitIdf() {
        return this.suitIdf;
    }

    public void setArmorData(ArmorDataManager.ArmorDataSupplier supplier) {
        this.armorData = supplier.get();
        this.material = new AbstractArmorMaterial(this);
    }

    @NotNull
    public ArmorMaterial m_40401_() {
        return this.material == null ? super.m_40401_() : this.material;
    }

    public int m_40404_() {
        return ArmorData.getByType(this.armorData, this.f_265916_, 0, ArmorPartData::getDefense);
    }

    public float m_40405_() {
        return ArmorData.getByType(this.armorData, this.f_265916_, 0, ArmorPartData::getToughness).intValue();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxDurability();
    }

    public int getMaxDurability() {
        return ArmorData.getByType(this.armorData, this.f_265916_, 0, ArmorPartData::getMaxDurability);
    }

    public int getKnockbackResistance() {
        return ArmorData.getByType(this.armorData, this.f_265916_, 0, ArmorPartData::getKnockbackResistance);
    }

    public int m_6473_() {
        return ArmorData.getByType(this.armorData, this.f_265916_, 5, ArmorPartData::getEnchantmentValue);
    }

    public boolean isDamageable(ItemStack stack) {
        return this.getMaxDamage(stack) > 0;
    }

    public boolean m_41465_() {
        return this.getMaxDurability() > 0;
    }

    @NotNull
    public SoundEvent m_150681_() {
        return ArmorData.getByType(this.armorData, this.f_265916_, SoundEvents.f_11678_, ArmorPartData::getEquipSound);
    }

    public boolean m_6832_(@NotNull ItemStack pToRepair, @NotNull ItemStack pRepair) {
        Ingredient ingredient = this.getIngredient();
        if (ingredient != null) {
            return ingredient.test(pRepair);
        }
        return false;
    }

    @Nullable
    public Ingredient getIngredient() {
        return ArmorData.getByType(this.armorData, this.f_265916_, null, ArmorPartData::getRepairIngredient);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        return (Boolean)CommonConfig.enableArmorAttribute.get() != false && pEquipmentSlot == this.f_265916_.m_266308_() ? ArmorData.getByType(this.armorData, this.f_265916_, ImmutableMultimap.of(), ArmorPartData::getAttributes) : ImmutableMultimap.of();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new BedrockArmorRenderer(LrArmorItem.this.getSuitIdf());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(DefaultAnimations.IDLE);
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag tooltipFlag) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            MutableComponent title = Component.m_237110_((String)"tooltip.lramrmor.suit", (Object[])new Object[]{Component.m_237115_((String)("suit.lrarmor." + this.suitIdf)), Component.m_237113_((String)String.format("(%d/4)", this.getSuitCount((Player)player, stack)))}).m_130940_(ChatFormatting.GRAY);
            list.add((Component)title);
            boolean flag = true;
            LrArmorItem item = (LrArmorItem)stack.m_41720_();
            ItemStack equipItem = player.m_6844_(item.m_40402_());
            if (!stack.equals(equipItem)) {
                flag = false;
            }
            for (ArmorItem.Type slot : ArmorItem.Type.values()) {
                MutableComponent part = Component.m_237115_((String)("item.lrarmor." + this.suitIdf + "_" + slot.m_266355_()));
                if (flag && this.isPartEquipped((Player)player, slot)) {
                    part.m_130940_(ChatFormatting.GREEN);
                } else {
                    part.m_130940_(ChatFormatting.GRAY);
                }
                list.add((Component)part);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "lrarmor:textures/item/armor/" + this.suitIdf + ".png";
    }

    public void applyEffect(Player player) {
        if (this.suitEffect == null) {
            return;
        }
        MobEffect effect = this.suitEffect.get();
        if (effect != null) {
            player.m_7292_(new MobEffectInstance(effect, 250));
        }
    }

    public boolean isPartEquipped(Player player, ArmorItem.Type slot) {
        ItemStack equipItem = player.m_6844_(slot.m_266308_());
        Item item = equipItem.m_41720_();
        if (item instanceof LrArmorItem) {
            LrArmorItem item2 = (LrArmorItem)item;
            return item2.getSuitIdf().equals(this.suitIdf);
        }
        return false;
    }

    public int getSuitCount(Player player, @Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof LrArmorItem)) {
            return 0;
        }
        LrArmorItem item2 = (LrArmorItem)item;
        ItemStack equipItem = player.m_6844_(item2.m_40402_());
        if (!stack.equals(equipItem)) {
            return 0;
        }
        return this.getSuitCount(player);
    }

    public int getSuitCount(Player player) {
        return LrArmorItem.getSuitCount(player, this.suitIdf);
    }

    public static int getSuitCount(Player player, String suitIdf) {
        int cnt = 0;
        for (ArmorItem.Type slot : ArmorItem.Type.values()) {
            LrArmorItem item1;
            ItemStack stack1 = player.m_6844_(slot.m_266308_());
            Item item = stack1.m_41720_();
            if (!(item instanceof LrArmorItem) || !(item1 = (LrArmorItem)item).getSuitIdf().equals(suitIdf)) continue;
            ++cnt;
        }
        return cnt;
    }
}

