/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.registries;

import fr.iglee42.evolvedmekanism.blocks.EMBlockResource;
import fr.iglee42.evolvedmekanism.items.EMItemBlockResource;
import fr.iglee42.evolvedmekanism.registries.EMBlockResourceInfo;
import fr.iglee42.evolvedmekanism.registries.EMBlockTypes;
import fr.iglee42.evolvedmekanism.tiers.cable.EMCableTier;
import fr.iglee42.evolvedmekanism.tiers.cable.EMConductorTier;
import fr.iglee42.evolvedmekanism.tiers.cable.EMPipeTier;
import fr.iglee42.evolvedmekanism.tiers.cable.EMTransporterTier;
import fr.iglee42.evolvedmekanism.tiers.cable.EMTubeTier;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.tier.ITier;
import mekanism.common.block.BlockEnergyCube;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.basic.BlockBin;
import mekanism.common.block.basic.BlockFluidTank;
import mekanism.common.block.prefab.BlockFactoryMachine;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.block.transmitter.BlockLogisticalTransporter;
import mekanism.common.block.transmitter.BlockMechanicalPipe;
import mekanism.common.block.transmitter.BlockPressurizedTube;
import mekanism.common.block.transmitter.BlockThermodynamicConductor;
import mekanism.common.block.transmitter.BlockUniversalCable;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.Factory;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.item.block.ItemBlockEnergyCube;
import mekanism.common.item.block.ItemBlockInductionCell;
import mekanism.common.item.block.ItemBlockInductionProvider;
import mekanism.common.item.block.machine.ItemBlockFactory;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.item.block.transmitter.ItemBlockLogisticalTransporter;
import mekanism.common.item.block.transmitter.ItemBlockMechanicalPipe;
import mekanism.common.item.block.transmitter.ItemBlockPressurizedTube;
import mekanism.common.item.block.transmitter.ItemBlockThermodynamicConductor;
import mekanism.common.item.block.transmitter.ItemBlockUniversalCable;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.tier.CableTier;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tier.PipeTier;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tier.TubeTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;

public class EMBlocks {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("evolvedmekanism");
    public static final BlockRegistryObject<EMBlockResource, EMItemBlockResource> BETTER_GOLD_BLOCK = EMBlocks.registerResourceBlock(EMBlockResourceInfo.BETTER_GOLD);
    public static final BlockRegistryObject<EMBlockResource, EMItemBlockResource> PLASLITHERITE_BLOCK = EMBlocks.registerResourceBlock(EMBlockResourceInfo.PLASLITHERITE);
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> OVERCLOCKED_BIN = EMBlocks.registerBin(EMBlockTypes.OVERCLOCKED_BIN);
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> QUANTUM_BIN = EMBlocks.registerBin(EMBlockTypes.QUANTUM_BIN);
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> DENSE_BIN = EMBlocks.registerBin(EMBlockTypes.DENSE_BIN);
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> MULTIVERSAL_BIN = EMBlocks.registerBin(EMBlockTypes.MULTIVERSAL_BIN);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> OVERCLOCKED_INDUCTION_CELL = EMBlocks.registerInductionCell(EMBlockTypes.OVERCLOCKED_INDUCTION_CELL);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> QUANTUM_INDUCTION_CELL = EMBlocks.registerInductionCell(EMBlockTypes.QUANTUM_INDUCTION_CELL);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> DENSE_INDUCTION_CELL = EMBlocks.registerInductionCell(EMBlockTypes.DENSE_INDUCTION_CELL);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> MULTIVERSAL_INDUCTION_CELL = EMBlocks.registerInductionCell(EMBlockTypes.MULTIVERSAL_INDUCTION_CELL);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> OVERCLOCKED_INDUCTION_PROVIDER = EMBlocks.registerInductionProvider(EMBlockTypes.OVERCLOCKED_INDUCTION_PROVIDER);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> QUANTUM_INDUCTION_PROVIDER = EMBlocks.registerInductionProvider(EMBlockTypes.QUANTUM_INDUCTION_PROVIDER);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> DENSE_INDUCTION_PROVIDER = EMBlocks.registerInductionProvider(EMBlockTypes.DENSE_INDUCTION_PROVIDER);
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> MULTIVERSAL_INDUCTION_PROVIDER = EMBlocks.registerInductionProvider(EMBlockTypes.MULTIVERSAL_INDUCTION_PROVIDER);
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> OVERCLOCKED_FLUID_TANK = EMBlocks.registerFluidTank(EMBlockTypes.OVERCLOCKED_FLUID_TANK);
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> QUANTUM_FLUID_TANK = EMBlocks.registerFluidTank(EMBlockTypes.QUANTUM_FLUID_TANK);
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> DENSE_FLUID_TANK = EMBlocks.registerFluidTank(EMBlockTypes.DENSE_FLUID_TANK);
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> MULTIVERSAL_FLUID_TANK = EMBlocks.registerFluidTank(EMBlockTypes.MULTIVERSAL_FLUID_TANK);
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> OVERCLOCKED_ENERGY_CUBE = EMBlocks.registerEnergyCube(EMBlockTypes.OVERCLOCKED_ENERGY_CUBE);
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> QUANTUM_ENERGY_CUBE = EMBlocks.registerEnergyCube(EMBlockTypes.QUANTUM_ENERGY_CUBE);
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> DENSE_ENERGY_CUBE = EMBlocks.registerEnergyCube(EMBlockTypes.DENSE_ENERGY_CUBE);
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> MULTIVERSAL_ENERGY_CUBE = EMBlocks.registerEnergyCube(EMBlockTypes.MULTIVERSAL_ENERGY_CUBE);
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> OVERCLOCKED_UNIVERSAL_CABLE = EMBlocks.registerUniversalCable(EMCableTier.OVERCLOCKED);
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> QUANTUM_UNIVERSAL_CABLE = EMBlocks.registerUniversalCable(EMCableTier.QUANTUM);
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> DENSE_UNIVERSAL_CABLE = EMBlocks.registerUniversalCable(EMCableTier.DENSE);
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> MULTIVERSAL_UNIVERSAL_CABLE = EMBlocks.registerUniversalCable(EMCableTier.MULTIVERSAL);
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> OVERCLOCKED_MECHANICAL_PIPE = EMBlocks.registerMechanicalPipe(EMPipeTier.OVERCLOCKED);
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> QUANTUM_MECHANICAL_PIPE = EMBlocks.registerMechanicalPipe(EMPipeTier.QUANTUM);
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> DENSE_MECHANICAL_PIPE = EMBlocks.registerMechanicalPipe(EMPipeTier.DENSE);
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> MULTIVERSAL_MECHANICAL_PIPE = EMBlocks.registerMechanicalPipe(EMPipeTier.MULTIVERSAL);
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> OVERCLOCKED_PRESSURIZED_TUBE = EMBlocks.registerPressurizedTube(EMTubeTier.OVERCLOCKED);
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> QUANTUM_PRESSURIZED_TUBE = EMBlocks.registerPressurizedTube(EMTubeTier.QUANTUM);
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> DENSE_PRESSURIZED_TUBE = EMBlocks.registerPressurizedTube(EMTubeTier.DENSE);
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> MULTIVERSAL_PRESSURIZED_TUBE = EMBlocks.registerPressurizedTube(EMTubeTier.MULTIVERSAL);
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> OVERCLOCKED_LOGISTICAL_TRANSPORTER = EMBlocks.registerLogisticalTransporter(EMTransporterTier.OVERCLOCKED);
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> QUANTUM_LOGISTICAL_TRANSPORTER = EMBlocks.registerLogisticalTransporter(EMTransporterTier.QUANTUM);
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> DENSE_LOGISTICAL_TRANSPORTER = EMBlocks.registerLogisticalTransporter(EMTransporterTier.DENSE);
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> MULTIVERSAL_LOGISTICAL_TRANSPORTER = EMBlocks.registerLogisticalTransporter(EMTransporterTier.MULTIVERSAL);
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> OVERCLOCKED_THERMODYNAMIC_CONDUCTOR = EMBlocks.registerThermodynamicConductor(EMConductorTier.OVERCLOCKED);
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> QUANTUM_THERMODYNAMIC_CONDUCTOR = EMBlocks.registerThermodynamicConductor(EMConductorTier.QUANTUM);
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> DENSE_THERMODYNAMIC_CONDUCTOR = EMBlocks.registerThermodynamicConductor(EMConductorTier.DENSE);
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> MULTIVERSAL_THERMODYNAMIC_CONDUCTOR = EMBlocks.registerThermodynamicConductor(EMConductorTier.MULTIVERSAL);
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> OVERCLOCKED_CHEMICAL_TANK = EMBlocks.registerChemicalTank(EMBlockTypes.OVERCLOCKED_CHEMICAL_TANK);
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> QUANTUM_CHEMICAL_TANK = EMBlocks.registerChemicalTank(EMBlockTypes.QUANTUM_CHEMICAL_TANK);
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> DENSE_CHEMICAL_TANK = EMBlocks.registerChemicalTank(EMBlockTypes.DENSE_CHEMICAL_TANK);
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> MULTIVERSAL_CHEMICAL_TANK = EMBlocks.registerChemicalTank(EMBlockTypes.MULTIVERSAL_CHEMICAL_TANK);

    private static BlockRegistryObject<BlockBin, ItemBlockBin> registerBin(BlockTypeTile<TileEntityBin> type) {
        return EMBlocks.registerTieredBlock(type, "_bin", (MapColor color) -> new BlockBin(type, properties -> properties.m_284180_(color)), ItemBlockBin::new);
    }

    private static BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> registerInductionCell(BlockTypeTile<TileEntityInductionCell> type) {
        return EMBlocks.registerTieredBlock(type, "_induction_cell", (MapColor color) -> new BlockTile(type, properties -> properties.m_284180_(color)), ItemBlockInductionCell::new);
    }

    private static BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> registerInductionProvider(BlockTypeTile<TileEntityInductionProvider> type) {
        return EMBlocks.registerTieredBlock(type, "_induction_provider", (MapColor color) -> new BlockTile(type, properties -> properties.m_284180_(color)), ItemBlockInductionProvider::new);
    }

    private static BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> registerFluidTank(Machine<TileEntityFluidTank> type) {
        return EMBlocks.registerTieredBlock(type, "_fluid_tank", () -> new BlockFluidTank(type), ItemBlockFluidTank::new);
    }

    private static BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> registerEnergyCube(Machine<TileEntityEnergyCube> type) {
        return EMBlocks.registerTieredBlock(type, "_energy_cube", () -> new BlockEnergyCube(type), ItemBlockEnergyCube::new);
    }

    private static BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> registerUniversalCable(CableTier tier) {
        return EMBlocks.registerTieredBlock((ITier)tier, "_universal_cable", () -> new BlockUniversalCable(tier), ItemBlockUniversalCable::new);
    }

    private static BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> registerMechanicalPipe(PipeTier tier) {
        return EMBlocks.registerTieredBlock((ITier)tier, "_mechanical_pipe", () -> new BlockMechanicalPipe(tier), ItemBlockMechanicalPipe::new);
    }

    private static BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> registerPressurizedTube(TubeTier tier) {
        return EMBlocks.registerTieredBlock((ITier)tier, "_pressurized_tube", () -> new BlockPressurizedTube(tier), ItemBlockPressurizedTube::new);
    }

    private static BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> registerLogisticalTransporter(TransporterTier tier) {
        return EMBlocks.registerTieredBlock((ITier)tier, "_logistical_transporter", () -> new BlockLogisticalTransporter(tier), ItemBlockLogisticalTransporter::new);
    }

    private static BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> registerThermodynamicConductor(ConductorTier tier) {
        return EMBlocks.registerTieredBlock((ITier)tier, "_thermodynamic_conductor", () -> new BlockThermodynamicConductor(tier), ItemBlockThermodynamicConductor::new);
    }

    private static BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalTank, Machine<TileEntityChemicalTank>>, ItemBlockChemicalTank> registerChemicalTank(Machine<TileEntityChemicalTank> type) {
        return EMBlocks.registerTieredBlock(type, "_chemical_tank", (MapColor color) -> new BlockTile.BlockTileModel((BlockTypeTile)type, properties -> properties.m_284180_(color)), ItemBlockChemicalTank::new);
    }

    private static <TILE extends TileEntityFactory<?>> BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory> registerFactory(Factory<TILE> type) {
        return EMBlocks.registerTieredBlock(type, "_" + type.getFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockFactoryMachine.BlockFactory(type), ItemBlockFactory::new);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Function<MapColor, ? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        ITier tier = ((AttributeTier)type.get(AttributeTier.class)).tier();
        return EMBlocks.registerTieredBlock(tier, suffix, () -> (Block)blockSupplier.apply(tier.getBaseTier().getMapColor()), itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return EMBlocks.registerTieredBlock(((AttributeTier)type.get(AttributeTier.class)).tier(), suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    private static BlockRegistryObject<EMBlockResource, EMItemBlockResource> registerResourceBlock(EMBlockResourceInfo resource) {
        return BLOCKS.registerDefaultProperties("block_" + resource.getRegistrySuffix(), () -> new EMBlockResource(resource), (block, properties) -> {
            if (!block.getResourceInfo().burnsInFire()) {
                properties = properties.m_41486_();
            }
            return new EMItemBlockResource((EMBlockResource)((Object)block), (Item.Properties)properties);
        });
    }
}

