/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.tile;

import dev.shadowsoffire.hostilenetworks.data.CachedModel;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import java.util.function.Consumer;
import net.lmor.extrahnn.ExtraHostile;
import net.lmor.extrahnn.ExtraHostileConfig;
import net.lmor.extrahnn.data.ExtraCachedModel;
import net.lmor.extrahnn.data.ExtraModelTier;
import net.lmor.extrahnn.item.ExtraDataModelItem;
import net.lmor.extrahnn.item.UpgradeMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class SimulationModelingTileEntity
extends BlockEntity
implements TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister {
    private static final int SIZE_SLOTS = 3;
    protected final SimulatorModelingItemHandler inventory = new SimulatorModelingItemHandler();
    protected final ModifiableEnergyStorage energy;
    protected final SimpleDataSlots data;
    protected int runtime;
    private int runtimeUpgrade = this.runtime = ExtraHostileConfig.simulationModelingPowerDuration;
    private int energyCost = ExtraHostileConfig.simulationModelingPowerCost;
    private boolean upgradeSpeed;
    private boolean upgradeModuleStack;
    private boolean upgradeDataKill;
    private boolean startCraft = false;

    public SimulationModelingTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExtraHostile.TileEntities.SIMULATOR_MODELING.get(), pos, state);
        this.energy = new ModifiableEnergyStorage(ExtraHostileConfig.simulationModelingPowerCap, ExtraHostileConfig.simulationModelingPowerCap);
        this.data = new SimpleDataSlots();
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addEnergy(this.energy);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.energy.setEnergy(tag.m_128451_("energy"));
        this.runtime = tag.m_128451_("runtime");
        this.startCraft = tag.m_128471_("startCraft");
        this.checkUpgrade();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("energy", this.energy.getEnergyStored());
        tag.m_128405_("runtime", this.runtime);
        tag.m_128379_("startCraft", this.startCraft);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void checkUpgrade() {
        this.upgradeSpeed = false;
        this.upgradeModuleStack = false;
        this.upgradeDataKill = false;
        this.energyCost = ExtraHostileConfig.simulationModelingPowerCost;
        this.runtimeUpgrade = ExtraHostileConfig.simulationModelingPowerDuration;
        for (int i = 1; i < 3; ++i) {
            Item upgrade = this.inventory.getStackInSlot(i).m_41720_();
            if (upgrade == ExtraHostile.Items.UPGRADE_SPEED.get()) {
                this.upgradeSpeed = true;
            }
            if (upgrade == ExtraHostile.Items.UPGRADE_MODULE_STACK.get()) {
                this.upgradeModuleStack = true;
            }
            if (upgrade != ExtraHostile.Items.UPGRADE_DATA_KILL.get()) continue;
            this.upgradeDataKill = true;
        }
        if (this.upgradeModuleStack) {
            this.energyCost = Math.min(ExtraHostileConfig.simulationModelingPowerCap, ExtraHostileConfig.upgradeModuleStackCost);
        }
        if (this.upgradeSpeed) {
            this.runtimeUpgrade = (int)Math.max(0.0f, (float)ExtraHostileConfig.simulationModelingPowerDuration * (1.0f - (float)ExtraHostileConfig.upgradeSpeed / 100.0f));
            this.energyCost = (int)Math.min((float)ExtraHostileConfig.simulationModelingPowerCap, (float)this.energyCost * ExtraHostileConfig.upgradeSpeedEnergy);
            if (this.runtimeUpgrade < this.runtime) {
                this.runtime = this.runtimeUpgrade;
            }
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (!this.startCraft) {
            return;
        }
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            this.runtime = 0;
            return;
        }
        if (this.inventory.getStackInSlot(0).m_41720_() instanceof DataModelItem && new CachedModel(this.inventory.getStackInSlot(0), 0).getTier() == ModelTier.SELF_AWARE || this.inventory.getStackInSlot(0).m_41720_() instanceof ExtraDataModelItem && new ExtraCachedModel(this.inventory.getStackInSlot(0), 0).getTier() == ExtraModelTier.OMNIPOTENT) {
            this.startCraft = false;
        }
        if (this.runtime == 0) {
            this.runtime = this.runtimeUpgrade;
            this.m_6596_();
        } else if (this.getEnergyStored() >= this.energyCost) {
            if (--this.runtime == 0) {
                this.result();
            } else {
                this.energy.setEnergy(this.energy.getEnergyStored() - this.energyCost);
                this.m_6596_();
            }
        }
    }

    public void result() {
        ItemStack item = this.inventory.getStackInSlot(0);
        if (item.m_41720_() instanceof DataModelItem) {
            CachedModel model = new CachedModel(item, 0);
            ModelTier tier = model.getTier();
            if (tier != tier.next()) {
                if (this.upgradeModuleStack) {
                    model.setData(model.getNextTierData());
                } else {
                    int newData = model.getData() + model.getDataPerKill() * (this.upgradeDataKill ? ExtraHostileConfig.upgradeDataKill : 1);
                    if (newData <= model.getNextTierData()) {
                        model.setData(newData);
                    }
                }
            }
            DataModelItem.setIters((ItemStack)item, (int)(DataModelItem.getIters((ItemStack)item) + (this.upgradeDataKill ? ExtraHostileConfig.upgradeDataKill : 1)));
            this.m_6596_();
        } else if (item.m_41720_() instanceof ExtraDataModelItem) {
            ExtraCachedModel model = new ExtraCachedModel(item, 0);
            ExtraModelTier tier = model.getTier();
            if (tier != tier.next()) {
                if (this.upgradeModuleStack) {
                    model.setData(model.getNextTierData());
                } else {
                    int newData = model.getData() + model.getDataPerKill() * (this.upgradeDataKill ? ExtraHostileConfig.upgradeDataKill : 1);
                    if (newData <= model.getNextTierData()) {
                        model.setData(newData);
                    }
                }
            }
            ExtraDataModelItem.setIters(item, ExtraDataModelItem.getIters(item) + (this.upgradeDataKill ? ExtraHostileConfig.upgradeDataKill : 1));
            this.m_6596_();
        }
    }

    public SimulatorModelingItemHandler getInventory() {
        return this.inventory;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getRuntimeUpgrade() {
        return this.runtimeUpgrade;
    }

    public boolean getUpgradeDataKill() {
        return this.upgradeDataKill;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return cap == ForgeCapabilities.ENERGY ? LazyOptional.of(() -> this.energy).cast() : super.getCapability(cap, side);
    }

    public class SimulatorModelingItemHandler
    extends InternalItemHandler {
        public SimulatorModelingItemHandler() {
            super(3);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() instanceof DataModelItem && new CachedModel(stack, 0).getTier() != ModelTier.SELF_AWARE || stack.m_41720_() instanceof ExtraDataModelItem && new ExtraCachedModel(stack, 0).getTier() != ExtraModelTier.OMNIPOTENT;
            }
            if (slot >= 1 && slot < 3) {
                return stack.m_41720_() instanceof UpgradeMachine;
            }
            return false;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack;
            if (slot == 0 && ((stack = SimulationModelingTileEntity.this.inventory.getStackInSlot(0)).m_41720_() instanceof DataModelItem && new CachedModel(stack, 0).getTier() == ModelTier.SELF_AWARE || stack.m_41720_() instanceof ExtraDataModelItem && new ExtraCachedModel(stack, 0).getTier() == ExtraModelTier.OMNIPOTENT)) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        protected void onContentsChanged(int slot) {
            SimulationModelingTileEntity.this.m_6596_();
            SimulationModelingTileEntity.this.checkUpgrade();
            SimulationModelingTileEntity.this.startCraft = true;
        }
    }
}

