/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.gui;

import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import dev.shadowsoffire.placebo.screen.TickableText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.lmor.extrahnn.ExtraHostileConfig;
import net.lmor.extrahnn.ExtraHostileNetworks;
import net.lmor.extrahnn.gui.MergerCameraContainer;
import net.lmor.extrahnn.tile.MergerCameraTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class MergerCameraScreen
extends PlaceboContainerScreen<MergerCameraContainer> {
    public static final int WIDTH = 216;
    public static final int HEIGHT = 241;
    private static final ResourceLocation BASE = ExtraHostileNetworks.local("textures/gui/merger_camera.png");
    private static final ResourceLocation PLAYER = ExtraHostileNetworks.local("textures/gui/inventory.png");
    private List<TickableText> body = new ArrayList<TickableText>(7);
    private MergerCameraTileEntity.FailureState lastFailState = MergerCameraTileEntity.FailureState.NONE;
    private boolean runtimeTextLoaded = false;
    private static final Component ERROR = Component.m_237113_((String)"ERROR").m_130940_(ChatFormatting.OBFUSCATED);

    public MergerCameraScreen(MergerCameraContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 216;
        this.f_97727_ = 241;
    }

    protected void m_280072_(GuiGraphics gfx, int pX, int pY) {
        if (this.m_6774_(203, 59, 7, 87, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((MergerCameraContainer)this.f_97732_).getEnergyStored(), ExtraHostileConfig.mergerCameraPowerCap}));
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.cost", (Object[])new Object[]{ExtraHostileConfig.mergerCameraPowerCost}));
            gfx.m_280666_(this.f_96547_, txt, pX, pY);
        } else {
            super.m_280072_(gfx, pX, pY);
        }
    }

    protected void m_280003_(GuiGraphics gfx, int pX, int pY) {
        int runtime = ((MergerCameraContainer)this.f_97732_).getRuntime();
        if (runtime > 0) {
            int rTime = Math.min(99, Mth.m_14167_((float)(100.0f * (float)(ExtraHostileConfig.mergerCameraPowerDuration - runtime) / (float)ExtraHostileConfig.mergerCameraPowerDuration)));
            gfx.m_280056_(this.f_96547_, rTime + "%", 178, 135, 6478079, true);
        }
        int left = 10;
        int top = 62;
        Objects.requireNonNull(this.f_96547_);
        int spacing = 12;
        int idx = 0;
        for (TickableText t : this.body) {
            t.render(this.f_96547_, gfx, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 10;
                continue;
            }
            left += t.getWidth(this.f_96547_);
        }
    }

    protected void m_7286_(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.m_280163_(BASE, left, top, 0.0f, 0.0f, 216, 152, 256, 256);
        int runtime = ((MergerCameraContainer)this.f_97732_).getRuntime();
        int dur = ExtraHostileConfig.mergerCameraPowerDuration;
        int part = runtime == 0 ? 0 : Mth.m_14167_((float)(9.0f * (float)Math.min(dur - runtime, (int)((float)dur * 0.05f)) / (float)((int)((float)dur * 0.05f))));
        for (int i = 0; i < 2; ++i) {
            gfx.m_280163_(BASE, left + 62 + (i == 0 ? 0 : 18 - part), top + 27, i == 0 ? 0.0f : 9.0f, 177.0f, part, 1, 256, 256);
            gfx.m_280163_(BASE, left + 87 + (i == 0 ? 0 : 18 - part), top + 25, i == 0 ? 0.0f : 9.0f, 177.0f, part, 1, 256, 256);
            gfx.m_280163_(BASE, left + 111 + (i == 0 ? 0 : 18 - part), top + 25, i == 0 ? 0.0f : 9.0f, 177.0f, part, 1, 256, 256);
            gfx.m_280163_(BASE, left + 136 + (i == 0 ? 0 : 18 - part), top + 27, i == 0 ? 0.0f : 9.0f, 177.0f, part, 1, 256, 256);
        }
        if (runtime != 0 && (double)runtime < (double)dur * 0.95) {
            float min = Math.min((float)(dur - runtime), (float)dur * 0.55f);
            part = Mth.m_14167_((float)(16.0f * min / ((float)dur * 0.55f)));
            int part_2 = Mth.m_14167_((float)(5.0f * min / ((float)dur * 0.55f)));
            gfx.m_280163_(BASE, left + 70, top + 28, 0.0f, 192.0f, 2, part, 256, 256);
            gfx.m_280163_(BASE, left + 95, top + 26, 0.0f, 182.0f, 2, part_2, 256, 256);
            gfx.m_280163_(BASE, left + 119, top + 26, 0.0f, 182.0f, 2, part_2, 256, 256);
            gfx.m_280163_(BASE, left + 144, top + 28, 0.0f, 192.0f, 2, part, 256, 256);
            if (runtime < dur - (int)((float)dur * 0.45f)) {
                part = Mth.m_14167_((float)(27.0f * ((float)dur * 0.45f - (float)runtime) / ((float)dur * 0.45f)));
                gfx.m_280163_(BASE, left + 72, top + 42, 0.0f, 209.0f, part, 2, 256, 256);
                gfx.m_280163_(BASE, left + 117 + 27 - part, top + 42, 0.0f, 209.0f, part, 2, 256, 256);
                part = (int)Math.ceil(8.0f * ((float)dur * 0.6f - (float)runtime) / ((float)dur * 0.6f));
                gfx.m_280163_(BASE, left + 97, top + 29, 0.0f, 188.0f, part, 2, 256, 256);
                gfx.m_280163_(BASE, left + 111 + 8 - part, top + 29, 0.0f, 188.0f, part, 2, 256, 256);
                if ((double)runtime < (double)dur * 0.05) {
                    part = Mth.m_14167_((float)(3.0f * ((float)dur * 0.05f - (float)runtime) / ((float)dur * 0.05f)));
                    gfx.m_280163_(BASE, left + 103, top + 31, 3.0f, 182.0f, 2, part, 256, 256);
                    gfx.m_280163_(BASE, left + 111, top + 31, 3.0f, 182.0f, 2, part, 256, 256);
                }
            }
        }
        int energyHeight = 87 - Mth.m_14167_((float)(87.0f * (float)((MergerCameraContainer)this.f_97732_).getEnergyStored() / (float)ExtraHostileConfig.mergerCameraPowerCap));
        gfx.m_280163_(BASE, left + 203, top + 59, 216.0f, 0.0f, 7, energyHeight, 256, 256);
        gfx.m_280163_(PLAYER, left + 20, top + 153, 0.0f, 0.0f, 176, 90, 256, 256);
    }

    public void m_181908_() {
        if (((MergerCameraContainer)this.f_97732_).getFailState() != MergerCameraTileEntity.FailureState.NONE) {
            MergerCameraTileEntity.FailureState oState = this.lastFailState;
            this.lastFailState = ((MergerCameraContainer)this.f_97732_).getFailState();
            if (oState != this.lastFailState) {
                String[] msg;
                this.body.clear();
                String[] msg1 = msg = I18n.m_118938_((String)this.lastFailState.getKey(), (Object[])new Object[0]).split("\\n");
                int i = msg.length;
                for (int j = 0; j < i; ++j) {
                    String key = msg1[j];
                    this.body.add(new TickableText(key, 0xFFFFFF));
                }
            }
            this.runtimeTextLoaded = false;
        } else if (!this.runtimeTextLoaded) {
            int ticks = ExtraHostileConfig.mergerCameraPowerDuration - ((MergerCameraContainer)this.f_97732_).getRuntime();
            float speed = 0.35f;
            this.body.clear();
            int iters = DataModelItem.getIters((ItemStack)((MergerCameraContainer)this.f_97732_).m_38853_(0).m_7993_());
            for (int i = 0; i < 7; ++i) {
                TickableText txt = new TickableText(I18n.m_118938_((String)("extrahnn.merger_camera.run." + i), (Object[])new Object[]{iters}), 0xFFFFFF, i != 0 && i != 5, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                if (i == 0) {
                    txt = new TickableText("v" + ExtraHostileNetworks.VERSION, ChatFormatting.GOLD.m_126665_().intValue(), true, speed);
                    this.body.add(txt.setTicks(ticks));
                    ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                    continue;
                }
                if (i != 5) continue;
                String key = Component.m_237115_((String)("extrahnn.fail.overheat." + (((MergerCameraContainer)this.f_97732_).getOverheat() ? "on" : "off"))).getString();
                txt = new TickableText(I18n.m_118938_((String)key, (Object[])new Object[0]), (((MergerCameraContainer)this.f_97732_).getOverheat() ? ChatFormatting.RED : ChatFormatting.AQUA).m_126665_().intValue(), true, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
            }
            this.runtimeTextLoaded = true;
            this.lastFailState = MergerCameraTileEntity.FailureState.NONE;
        }
        TickableText.tickList(this.body);
        if (((MergerCameraContainer)this.f_97732_).getRuntime() == 0) {
            this.runtimeTextLoaded = false;
        }
    }
}

