/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.forge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import me.codexadrian.tempad.client.TempadClient;
import me.codexadrian.tempad.client.render.TimedoorRenderer;
import me.codexadrian.tempad.common.BlurReloader;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import me.codexadrian.tempad.common.utils.ClientUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="tempad", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeTempadClient {
    public static ShaderInstance timedoorShader;
    public static final BlurReloader BLUR_RELOADER;
    private static final KeyMapping SHORTCUT_KEYBIND;
    private static final KeyMapping FAVORITED_KEYBIND;

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TempadClient.init();
        EntityRenderers.m_174036_((EntityType)((EntityType)TempadRegistry.TIMEDOOR_ENTITY.get()), TimedoorRenderer::new);
        event.enqueueWork(TempadClient::initItemProperties);
        bus.register(ForgeTempadClient.class);
        MinecraftForge.EVENT_BUS.addListener(ForgeTempadClient::onClientTick);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("rendertype_timedoor"), DefaultVertexFormat.f_85820_), shaderInstance -> {
            timedoorShader = shaderInstance;
        });
    }

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(SHORTCUT_KEYBIND);
        event.register(FAVORITED_KEYBIND);
    }

    public static void registerBlurReloader() {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)BLUR_RELOADER);
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (SHORTCUT_KEYBIND.m_90859_()) {
                ClientUtils.openTempadbyShortcut();
            }
            while (FAVORITED_KEYBIND.m_90859_()) {
                ClientUtils.openFavorited();
            }
        }
    }

    static {
        BLUR_RELOADER = new BlurReloader();
        SHORTCUT_KEYBIND = new KeyMapping("key.tempad.shortcut", InputConstants.Type.KEYSYM, 66, "category.tempad.keybinds");
        FAVORITED_KEYBIND = new KeyMapping("key.tempad.favorite", InputConstants.Type.KEYSYM, 71, "category.tempad.keybinds");
    }
}

