/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.client.widgets.NewLocationModal;
import me.codexadrian.tempad.client.widgets.TemporaryWidget;
import me.codexadrian.tempad.client.widgets.TextEntry;
import me.codexadrian.tempad.common.config.ConfigCache;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.network.NetworkHandler;
import me.codexadrian.tempad.common.network.messages.c2s.AddLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.DeleteLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.ExportLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.FavoriteLocationPacket;
import me.codexadrian.tempad.common.network.messages.c2s.SummonTimedoorPacket;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsolidatedScreen
extends Screen {
    private static final ResourceLocation SCREEN = new ResourceLocation("tempad", "textures/widget/tempad_screen.png");
    private static final int TEMPAD_WIDTH = 249;
    private static final int TEMPAD_HEIGHT = 138;
    protected final List<TemporaryWidget> temporaryWidgets = new ArrayList<TemporaryWidget>();
    private final List<LocationData> locations;
    private UUID favorite;
    private LocationData selectedLocation;
    private SelectionList<TextEntry> informationPanel;
    private SelectionList<TextEntry> locationPanel;
    private Button favoriteButton;
    private Button unfavoriteButton;
    private Button downloadButton;
    private Button deleteButton;
    private Button teleportButton;

    public ConsolidatedScreen(List<LocationData> locations, UUID favorite) {
        super(Component.m_130674_((String)""));
        this.locations = locations;
        this.favorite = favorite;
    }

    protected void m_7856_() {
        super.m_7856_();
        int offset = 3;
        int cornerX = (this.f_96543_ - 249) / 2;
        int cornerY = (this.f_96544_ - 138) / 2;
        this.informationPanel = (SelectionList)this.m_142416_((GuiEventListener)new SelectionList(cornerX + 16, cornerY + 33, 91, 78, 10, textEntry -> {}));
        this.locationPanel = (SelectionList)this.m_142416_((GuiEventListener)new SelectionList(cornerX + 129, cornerY + 31, 91, 92, 10, textEntry -> {
            if (textEntry != null && textEntry.data != null) {
                this.selectedLocation = textEntry.data;
                this.informationPanel.updateEntries(List.of(new TextEntry((Component)Component.m_237113_((String)this.selectedLocation.getName())), new TextEntry((Component)Component.m_237110_((String)"gui.tempad.x", (Object[])new Object[]{Mth.m_14143_((float)this.selectedLocation.getBlockPos().m_123341_())})), new TextEntry((Component)Component.m_237110_((String)"gui.tempad.y", (Object[])new Object[]{Mth.m_14143_((float)this.selectedLocation.getBlockPos().m_123342_())})), new TextEntry((Component)Component.m_237110_((String)"gui.tempad.z", (Object[])new Object[]{Mth.m_14143_((float)this.selectedLocation.getBlockPos().m_123343_())})), new TextEntry((Component)Component.m_237110_((String)"gui.tempad.dimension", (Object[])new Object[]{Component.m_237115_((String)this.selectedLocation.getLevelKey().m_135782_().m_214296_("dimension"))}))));
                if (this.selectedLocation.getId().equals(this.favorite)) {
                    this.favoriteButton.f_93624_ = false;
                    this.unfavoriteButton.f_93624_ = true;
                } else {
                    this.favoriteButton.f_93624_ = true;
                    this.unfavoriteButton.f_93624_ = false;
                }
                this.downloadButton.f_93624_ = true;
                this.deleteButton.f_93624_ = true;
                this.teleportButton.f_93624_ = true;
                this.deleteButton.f_93623_ = this.selectedLocation.isDeletable();
                if (this.selectedLocation.isDeletable()) {
                    this.deleteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.delete")));
                } else {
                    this.deleteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.delete_disabled")));
                }
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    TempadItem tempadItem;
                    ItemStack itemInHand = TeleportUtils.findTempad((Player)this.f_96541_.f_91074_);
                    Item item = itemInHand.m_41720_();
                    boolean isTempadUsable = item instanceof TempadItem && (tempadItem = (TempadItem)item).getOption().canTimedoorOpen((Player)this.f_96541_.f_91074_, itemInHand);
                    boolean bl = this.teleportButton.f_93623_ = this.selectedLocation.isTeleportable() && TeleportUtils.mayTeleport(this.selectedLocation.getLevelKey(), (Player)this.f_96541_.f_91074_) && isTempadUsable;
                    if (this.selectedLocation.isTeleportable()) {
                        this.teleportButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.teleport")));
                    } else {
                        this.teleportButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.teleport_disabled")));
                    }
                    boolean bl2 = this.downloadButton.f_93623_ = this.selectedLocation.isDownloadable() && ConfigCache.allowExporting && (!ConfigCache.consumeCooldown || isTempadUsable);
                    if (this.selectedLocation.isDownloadable()) {
                        this.downloadButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.download")));
                    } else {
                        this.downloadButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.download_disabled")));
                    }
                }
            }
        }));
        if (this.locations.isEmpty()) {
            this.locationPanel.updateEntries(List.of(new TextEntry((Component)Component.m_237115_((String)"gui.tempad.no_locations.first_line")), new TextEntry((Component)Component.m_237115_((String)"gui.tempad.no_locations.second_line"))));
        } else {
            this.locationPanel.updateEntries(this.locations.stream().map(locationData -> new TextEntry((LocationData)locationData, locData -> locData.getId().equals(this.favorite))).toList());
            this.informationPanel.updateEntries(List.of(new TextEntry((Component)Component.m_237115_((String)"gui.tempad.no_selection.first_line")), new TextEntry((Component)Component.m_237115_((String)"gui.tempad.no_selection.second_line"))));
        }
        EditBox editBox = new EditBox(this.f_96547_, cornerX + 139, cornerY + 16, 66, 12, (Component)Component.m_237115_((String)"gui.tempad.search_field"));
        editBox.m_94182_(false);
        editBox.m_257771_((Component)Component.m_237115_((String)"gui.tempad.search_field"));
        editBox.m_94202_(TempadClientConfig.color);
        if (!this.locations.isEmpty()) {
            editBox.m_94151_(string -> this.locationPanel.updateEntries(this.locations.stream().filter(locationData -> locationData.getName().toLowerCase().contains(string.toLowerCase())).map(locationData -> new TextEntry((LocationData)locationData, locData -> locData.getId().equals(this.favorite))).toList()));
        }
        this.m_142416_((GuiEventListener)editBox);
        this.favoriteButton = (Button)this.m_142416_((GuiEventListener)new TempadButton(cornerX + 46, cornerY + 110, 14, 14, (Component)Component.m_237115_((String)"gui.tempad.favorite"), button -> this.favoriteAction(), 0));
        this.favoriteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.favorite")));
        this.favoriteButton.f_93624_ = false;
        this.unfavoriteButton = (Button)this.m_142416_((GuiEventListener)new TempadButton(cornerX + 46, cornerY + 110, 14, 14, (Component)Component.m_237115_((String)"gui.tempad.unfavorite"), button -> this.favoriteAction(), 1));
        this.unfavoriteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.unfavorite")));
        this.unfavoriteButton.f_93624_ = false;
        this.downloadButton = (Button)this.m_142416_((GuiEventListener)new TempadButton(cornerX + 62, cornerY + 110, 14, 14, (Component)Component.m_237115_((String)"gui.tempad.download"), button -> this.exportAction(), 2));
        this.downloadButton.f_93624_ = false;
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new TempadButton(cornerX + 78, cornerY + 110, 14, 14, (Component)Component.m_237115_((String)"gui.tempad.delete"), button -> this.deleteAction(), 3));
        this.deleteButton.f_93624_ = false;
        this.teleportButton = (Button)this.m_142416_((GuiEventListener)new TempadButton(cornerX + 94, cornerY + 110, 14, 14, (Component)Component.m_237115_((String)"gui.tempad.teleport"), button -> this.teleportAction(), 4));
        this.teleportButton.f_93624_ = false;
        ((TempadButton)this.m_142416_((GuiEventListener)new TempadButton(cornerX + 208, cornerY + 14, 12, 12, (Component)Component.m_237115_((String)"gui.tempad.add_location"), button -> this.openNewLocationModal(), 5))).m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.tempad.add_location")));
    }

    private void favoriteAction() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            if (this.selectedLocation.getId().equals(this.favorite)) {
                this.favorite = null;
                this.favoriteButton.f_93624_ = true;
                this.unfavoriteButton.f_93624_ = false;
            } else {
                this.favorite = this.selectedLocation.getId();
                this.favoriteButton.f_93624_ = false;
                this.unfavoriteButton.f_93624_ = true;
            }
            NetworkHandler.CHANNEL.sendToServer((Packet)new FavoriteLocationPacket(this.favorite));
        }
    }

    private void teleportAction() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new SummonTimedoorPacket(this.selectedLocation.getId(), TempadClientConfig.color));
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    private void deleteAction() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new DeleteLocationPacket(this.selectedLocation.getId()));
            this.locations.removeIf(locationData -> locationData.getId().equals(this.selectedLocation.getId()));
            this.selectedLocation = null;
            this.locationPanel.updateEntries(this.locations.stream().map(locationData -> new TextEntry((LocationData)locationData, locData -> locData.getId().equals(this.favorite))).toList());
            this.informationPanel.updateEntries(List.of(new TextEntry((Component)Component.m_237115_((String)"gui.tempad.no_selection.first_line")), new TextEntry((Component)Component.m_237115_((String)"gui.tempad.no_selection.second_line"))));
            this.favoriteButton.f_93624_ = false;
            this.unfavoriteButton.f_93624_ = false;
            this.downloadButton.f_93624_ = false;
            this.deleteButton.f_93624_ = false;
            this.teleportButton.f_93624_ = false;
        }
    }

    private void exportAction() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && ConfigCache.allowExporting) {
            Minecraft.m_91087_().m_91152_(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new ExportLocationPacket(this.selectedLocation.getId()));
        }
    }

    private void openNewLocationModal() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.findOrCreateEditWidget();
        }
    }

    private void newLocationAction(String name) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            Minecraft.m_91087_().m_91152_(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new AddLocationPacket(name));
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280411_(SCREEN, (this.f_96543_ - 249) / 2, (this.f_96544_ - 138) / 2, 249, 138, 0.0f, 0.0f, 249, 138, 256, 256);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int barHeight = 0;
        ItemStack tempad = TeleportUtils.findTempad((Player)this.f_96541_.f_91074_);
        Item item = tempad.m_41720_();
        if (item instanceof TempadItem) {
            TempadItem item2 = (TempadItem)item;
            TempadOption option = item2.getOption();
            barHeight = option.isDurabilityBarVisible(tempad) ? (int)(option.getPercentage(tempad) * 54.0) : (option.canTimedoorOpen((Player)this.f_96541_.f_91074_, tempad) ? 54 : 0);
            graphics.m_280411_(SCREEN, (this.f_96543_ - 249) / 2 + 234, (this.f_96544_ - 138) / 2 + 42 + 54 - barHeight, 6, barHeight, 249.0f, (float)(54 - barHeight), 6, barHeight, 256, 256);
            if (mouseX >= (this.f_96543_ - 249) / 2 + 234 && mouseX <= (this.f_96543_ - 249) / 2 + 240 && mouseY >= (this.f_96544_ - 138) / 2 + 42 && mouseY <= (this.f_96544_ - 138) / 2 + 96) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                option.addToolTip(tempad, (Level)this.f_96541_.f_91073_, tooltip, (TooltipFlag)TooltipFlag.f_256752_);
                graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public <R extends Renderable & TemporaryWidget> R addTemporary(R renderable) {
        this.m_169394_(renderable);
        this.temporaryWidgets.add(renderable);
        return renderable;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        boolean visible = false;
        for (TemporaryWidget widget : this.temporaryWidgets) {
            visible |= widget.isVisible();
            if (!widget.isVisible() || !(widget instanceof GuiEventListener)) continue;
            GuiEventListener listener = (GuiEventListener)widget;
            return listener;
        }
        if (visible) {
            return null;
        }
        return super.m_7222_();
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        ArrayList<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
        for (TemporaryWidget widget : this.temporaryWidgets) {
            if (!widget.isVisible() || !(widget instanceof GuiEventListener)) continue;
            GuiEventListener listener = (GuiEventListener)widget;
            listeners.add(listener);
        }
        if (!listeners.isEmpty()) {
            return listeners;
        }
        return super.m_6702_();
    }

    public List<TemporaryWidget> temporaryWidgets() {
        return this.temporaryWidgets;
    }

    public void findOrCreateEditWidget() {
        boolean found = false;
        NewLocationModal widget = new NewLocationModal(this.f_96543_, this.f_96544_, (this.f_96543_ - 249) / 2 + 70, (this.f_96544_ - 138) / 2 + 54, this::newLocationAction);
        for (TemporaryWidget temporaryWidget : this.temporaryWidgets()) {
            if (!(temporaryWidget instanceof NewLocationModal)) continue;
            NewLocationModal modal = (NewLocationModal)temporaryWidget;
            found = true;
            widget = modal;
            break;
        }
        widget.setVisible(true);
        if (!found) {
            this.addTemporary(widget);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static class TempadButton
    extends Button {
        private final int buttonOffset;

        protected TempadButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, int buttonOffset) {
            super(x, y, width, height, message, onPress, Button.f_252438_);
            this.buttonOffset = buttonOffset;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            guiGraphics.m_280411_(SCREEN, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), (float)(this.buttonOffset * 14), (float)this.getTextureY(), this.m_5711_(), this.m_93694_(), 256, 256);
        }

        protected int getTextureY() {
            int i = 0;
            if (!this.m_142518_()) {
                i = 2;
            } else if (this.m_274382_()) {
                i = 1;
            }
            return 138 + i * this.m_93694_();
        }
    }
}

