/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.client.renderer;

import com.haoict.tiab.common.entities.TimeAcceleratorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TimeAcceleratorEntityRenderer
extends EntityRenderer<TimeAcceleratorEntity> {
    public TimeAcceleratorEntityRenderer(EntityRendererProvider.Context erp) {
        super(erp);
    }

    public void render(TimeAcceleratorEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        String timeRate = "x" + 2 * entity.getTimeRate();
        float paddingLeftRight = 2 * entity.getTimeRate() < 10 ? 0.11f : 0.19f;
        this.drawText(matrixStack, bufferIn, timeRate, new Vector3f(-paddingLeftRight, 0.064f, 0.51f), Axis.f_252436_.m_252977_(0.0f), ChatFormatting.WHITE.m_126665_());
        this.drawText(matrixStack, bufferIn, timeRate, new Vector3f(paddingLeftRight, 0.064f, -0.51f), Axis.f_252436_.m_252977_(180.0f), ChatFormatting.WHITE.m_126665_());
        this.drawText(matrixStack, bufferIn, timeRate, new Vector3f(0.51f, 0.064f, paddingLeftRight), Axis.f_252436_.m_252977_(90.0f), ChatFormatting.WHITE.m_126665_());
        this.drawText(matrixStack, bufferIn, timeRate, new Vector3f(-0.51f, 0.064f, -paddingLeftRight), Axis.f_252436_.m_252977_(-90.0f), ChatFormatting.WHITE.m_126665_());
        this.drawText(matrixStack, bufferIn, timeRate, new Vector3f(-paddingLeftRight, 0.51f, -0.064f), Axis.f_252529_.m_252977_(90.0f), ChatFormatting.WHITE.m_126665_());
        this.drawText(matrixStack, bufferIn, timeRate, new Vector3f(-paddingLeftRight, -0.51f, 0.064f), Axis.f_252529_.m_252977_(-90.0f), ChatFormatting.WHITE.m_126665_());
    }

    public ResourceLocation getTextureLocation(TimeAcceleratorEntity entity) {
        return null;
    }

    private void drawText(PoseStack matrixStack, MultiBufferSource source, String text, Vector3f translateVector, Quaternionf rotate, int color) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(translateVector.x(), translateVector.y(), translateVector.z());
        matrixStack.m_85841_(0.02f, -0.02f, 0.02f);
        matrixStack.m_252781_(rotate);
        this.m_114481_().m_271703_(text, 0.0f, 0.0f, -1, false, matrixStack.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0, color);
        matrixStack.m_85849_();
    }
}

